# coding=utf-8

from sandbox.projects.metrika.admins.infra.api.method import Method


class Environments(Method):
    path = "environments"
    environment_path = "environments/{id}"
    mine_path = "environments/mine"
    mine_environment_path = "environments/mine/{id}"

    def get_all(self):
        return self._get(self.path)

    def create(self, environment):
        return self._post(self.path, environment)

    def get(self, environment_id):
        return self._get(self.environment_path.format(id=environment_id))

    def update(self, environment_id, environment):
        return self._put(self.environment_path.format(id=environment_id), environment)

    def delete(self, environment_id):
        return self._delete(self.environment_path.format(id=environment_id))

    def get_all_mine(self):
        return self._get(self.mine_path)

    def get_mine(self, environment_id):
        return self._get(self.mine_environment_path.format(id=environment_id))
