# coding=utf-8

from sandbox.projects.metrika.admins.infra.api.method import Method


class Events(Method):
    path = "events"
    event_path = "events/{id}"
    current_path = "events/current"

    def get_all(self, from_timestamp=None, to_timestamp=None, service_id=None, environment_id=None, event_type=None, severity=None, dcs=[]):
        return self._get(self.path, {
            "serviceId": service_id,
            "environmentId": environment_id,
            "from": from_timestamp,
            "to": to_timestamp,
            "type": event_type,
            "severity": severity,
            "dc": ",".join(dcs) if dcs else None
        })

    def create(self, event):
        return self._post(self.path, event)

    def get(self, event_id):
        return self._get(self.event_path.format(id=event_id))

    def update(self, event_id, event):
        return self._put(self.event_path.format(id=event_id), event)

    def delete(self, event_id):
        return self._delete(self.event_path.format(id=event_id))

    def get_current(self):
        return self._get(self.current_path)
