# coding=utf-8

from sandbox.projects.metrika.admins.infra.api.method import Method


class Namespaces(Method):
    path = "namespaces"
    namespace_path = "namespace/{id}"
    services_path = "namespace/{id}/services"

    def get_all(self):
        return self._get(self.path)

    def create(self, namespace):
        return self._post(self.path, namespace)

    def update(self, namespace_id, namespace):
        return self._put(self.event_path.format(id=namespace_id), namespace)

    def delete(self, namespace_id):
        return self._delete(self.event_path.format(id=namespace_id))

    def get_services(self, namespace_id):
        return self._get(self.services_path.format(id=namespace_id))
