# coding=utf-8

from sandbox.projects.metrika.admins.infra.api.method import Method


class Services(Method):
    path = "services"
    service_path = "services/{id}"
    mine_path = "services/mine"
    mine_service_path = "services/mine/{id}"

    def get_all(self):
        return self._get(self.path)

    def create(self, service):
        return self._post(self.path, service)

    def get(self, service_id):
        return self._get(self.service_path.format(id=service_id))

    def update(self, service_id, service):
        return self._put(self.service_path.format(id=service_id), service)

    def delete(self, service_id):
        return self._delete(self.service_path.format(id=service_id))

    def get_all_mine(self):
        return self._get(self.mine_path)

    def get_mine(self, service_id):
        return self._get(self.mine_service_path.format(id=service_id))
