# coding=utf-8


class Event(object):

    def __init__(self, id=None, title=None, description=None, service_id=None, environment_id=None, start_time=None, finish_time=None, type=None,
                 severity=None, man=False, myt=False, sas=False, vla=False, iva=False, tickets=None, meta={}, send_email_notifications=False, set_all_available_dc=False):
        self.id = id
        self.title = title
        self.description = description
        self.service_id = service_id
        self.environment_id = environment_id
        self.start_time = start_time
        self.finish_time = finish_time
        self.type = type
        self.severity = severity
        self.man = man
        self.myt = myt
        self.sas = sas
        self.vla = vla
        self.iva = iva
        self.tickets = tickets
        self.meta = meta
        self.send_email_notifications = send_email_notifications
        self.set_all_available_dc = set_all_available_dc

    @staticmethod
    def from_dict(event):
        return Event(
            id=event.get("id"),
            title=event.get("title"),
            description=event.get("description"),
            service_id=event.get("service_id"),
            environment_id=event.get("environment_id"),
            start_time=event.get("start_time"),
            finish_time=event.get("finish_time"),
            type=event.get("type"),
            severity=event.get("severity"),
            man=event.get("man"),
            myt=event.get("myt"),
            sas=event.get("sas"),
            vla=event.get("vla"),
            iva=event.get("iva"),
            tickets=event.get("tickets"),
            meta=event.get("meta"),
        )

    def to_dict(self):
        return {
            "title": self.title,
            "description": self.description,
            "serviceId": self.service_id,
            "environmentId": self.environment_id,
            "startTime": self.start_time,
            "finishTime": self.finish_time,
            "type": self.type,
            "severity": self.severity,
            "man": self.man,
            "myt": self.myt,
            "sas": self.sas,
            "vla": self.vla,
            "iva": self.iva,
            "tickets": self.tickets,
            "meta": self.meta,
            "sendEmailNotifications": self.send_email_notifications,
            "setAllAvailableDc": self.set_all_available_dc
        }
