# coding=utf-8
import logging
import os

from sandbox.common import fs
from sandbox.common.types import misc
from sandbox.projects.metrika.admins.lxc_containers import utils
from sandbox.projects.sandbox import resources, sandbox_lxc_image
from sandbox.projects.sandbox.sandbox_lxc_image import image

CUSTOM_PACKAGES = [
    "curl",
    "wget",
    "ca-certificates",
    "yandex-openjdk17",
    "maven",
    "gradle",
    "groovy",
    "devscripts",
    "jq",
    "python",
    "python-pip",
    "python-dev",
    "python-virtualenv",
    "p2p-distribution-geobase-tzdata-config=0.1-137",
    "p2p-distribution=0.1-137",
    "libffi-dev",
    "g++",
    "fakeroot",
    "alien",
    "dupload",
    "yandex-passport-vault-client=0.1.10",
    "yandex-python-sbdutils",
    "libticket-parser2-java"
]

CUSTOM_SCRIPT = [
    """
set -o errexit
set -o xtrace
tee /etc/apt/preferences.d/00-pin<<EOF
Package: *
Pin: release a=stable
Pin-Priority: 500
EOF
""",
    "apt-get purge --assume-yes --force-yes python-numpy python-chardet",
    "pip install --index-url https://pypi.yandex-team.ru/simple/ setuptools pymongo==3.7.2 yql==1.2.44",
    "pip --cert /etc/ssl/certs/YandexInternalRootCA.crt",
    "curl -sSf --output /etc/maven/settings.xml https://raw.github.yandex-team.ru/artifactory/settings.xml/668c99a3491036c750be08a08116afc1e2c2ffbc/settings.xml",
    "export LD_LIBRARY_PATH=/usr/local/lib"
]


class CreateCosmosLxcContainer(utils.NoCloneWarningMixin, sandbox_lxc_image.SandboxLxcImage):
    """
    Сборка контейера с окружением для тасок COSMOS_RUNNER и COSMOS_LAUNCHER
    """

    class Requirements(sandbox_lxc_image.SandboxLxcImage.Requirements):
        dns = misc.DnsType.DNS64

    class Parameters(sandbox_lxc_image.SandboxLxcImage.Parameters):
        description = "Metrika Cosmos"
        resource_description = sandbox_lxc_image.SandboxLxcImage.Parameters.resource_description(default="Metrika Cosmos Environment")
        custom_image = sandbox_lxc_image.SandboxLxcImage.Parameters.custom_image(default=True)
        ubuntu_release = sandbox_lxc_image.SandboxLxcImage.Parameters.ubuntu_release(default=sandbox_lxc_image.UbuntuRelease.TRUSTY)
        resource_type = sandbox_lxc_image.SandboxLxcImage.Parameters.resource_type(default=resources.LXC_CONTAINER.name)
        custom_repos = sandbox_lxc_image.SandboxLxcImage.Parameters.custom_repos(default="\n".join(utils.CUSTOM_REPOS_TRUSTY))
        custom_packages = sandbox_lxc_image.SandboxLxcImage.Parameters.custom_packages(default=" ".join(CUSTOM_PACKAGES))
        custom_script = sandbox_lxc_image.SandboxLxcImage.Parameters.custom_script(default="\n".join(CUSTOM_SCRIPT))
        install_common = sandbox_lxc_image.SandboxLxcImage.Parameters.install_common(default=True)
        custom_attrs = sandbox_lxc_image.SandboxLxcImage.Parameters.custom_attrs(default={"ttl": "inf", "purpose": "cosmos"})

    def postcook(self):
        super(CreateCosmosLxcContainer, self).postcook()
        sshd_config = fs.read_file(os.path.join(os.path.dirname(__file__), "sshd_config"))
        logging.info(self.add_config({"/etc/ssh/sshd_config": image.file_descr(content=sshd_config.splitlines())}))
