# coding=utf-8

from sandbox.common.types import misc
from sandbox.projects.metrika.admins.lxc_containers import utils
from sandbox.projects.sandbox import resources, sandbox_lxc_image

CUSTOM_PACKAGES = [
    "wget",
    "ca-certificates",
    "apt-transport-https",
    "autoconf",
    "autoconf-extra-archive",
    "autotools-dev",
    "build-essential",
    "brotli",
    "checkinstall",
    "curl",
    "debhelper",
    "debsigs",
    "devscripts",
    "dpatch",
    "dupload",
    "fakeroot",
    "libauth-client-parser-dev",
    "p2p-distribution=1.0-21",
    "p2p-distribution-geobase-tzdata-config=1.0-21",
    "libgeobase5-dev=5.0-43",
    "libgeobase5=5.0-43",
    "libglib2.0-dev",
    "libicu-dev",
    "liblbs-locator-metrika-dev",
    "liblzma-dev",
    "libmsgpack-metrika-dev",
    "libmysqlclient-dev",
    "libprotobuf-metrika-dev",
    "libreadline-dev",
    "libssl-dev",
    "libtcmalloc-metrika-dev",
    "libtool",
    "libuatraits-dev",
    "libxml2-dev",
    "libzookeeper-mt2",
    "libzookeeper-mt-dev",
    "scons",
    "subversion",
    "uatraits-data",
    "unixodbc-dev",
    "yandex-conf-hostname-long",
    "yandex-dh-environment",
    "yandex-dh-versions",
    "yandex-mobile-device-names",
    "ccache",
    "yandex-coverity",
    "pbuilder",
    "cdbs",
    "yandex-openjdk11",
    "ant",
    "ant-optional",
    "ivy",
    "junit4",
    "libjsch-java",
    "zip",
    "unzip",
    "groovy",
    "devscripts",
    "jq",
    "python",
    "python-dev",
    "xmlstarlet",
    "yandex-internal-root-ca",
    "yandex-zopfli",
    "libfontconfig",
    "software-properties-common",
]

CUSTOM_SCRIPT = [
    """
set -o errexit
set -o xtrace
tee /etc/apt/preferences.d/00-pin<<EOF
Package: *
Pin: release a=stable
Pin-Priority: 500
EOF""",
    """tee /etc/pbuilderrc<<EOF
ALLOWUNTRUSTED=yes
EOF
    """,
    """
    tee /etc/apt/sources.list.d/nodesource.com.list<<EOF
deb https://deb.nodesource.com/node_12.x trusty main
deb-src https://deb.nodesource.com/node_12.x trusty main
EOF""",
    "curl -sSfL https://deb.nodesource.com/gpgkey/nodesource.gpg.key | apt-key add -",
    "add-apt-repository ppa:ubuntu-toolchain-r/test",
    "apt-get update -y -qq",
    "apt-get install gcc-5 -y",
    "apt-get install g++-5 -y",
    "apt-get install -y libjsoncpp-dev=0.6.2-1yandex nodejs",
    """pbuilder create --othermirror "deb http://common.dist.yandex.ru/common/ stable/all/ | deb http://yandex-trusty.dist.yandex.ru/yandex-trusty/ stable/amd64/ | \
    deb http://mirror.corbina.net/ubuntu trusty main restricted universe multiverse" --override-config --extrapackages ca-certificates""",
    "ln -s /usr/share/java/ivy.jar /usr/share/ant/lib/ivy.jar",
    "ln -s /usr/share/java/jsch.jar /usr/share/ant/lib/jsch.jar",
    "ln -s /usr/share/java/junit4.jar /usr/share/ant/lib/junit4.jar",
    "curl https://snapshots.mitmproxy.org/5.0.1/mitmproxy-5.0.1-linux.tar.gz | tar -xz -C /usr/bin/"
]


class CreateKnightTrustyLxcContainer(utils.NoCloneWarningMixin, sandbox_lxc_image.SandboxLxcImage):
    """
    Сборка контейера с окружением, аналогичным Jenkins knight-trusty slave
    """

    class Requirements(sandbox_lxc_image.SandboxLxcImage.Requirements):
        dns = misc.DnsType.DNS64

    class Parameters(sandbox_lxc_image.SandboxLxcImage.Parameters):
        description = "Metrika Knight Trusty"
        resource_description = sandbox_lxc_image.SandboxLxcImage.Parameters.resource_description(default="Metrika Knight Environment")
        custom_image = sandbox_lxc_image.SandboxLxcImage.Parameters.custom_image(default=True)
        ubuntu_release = sandbox_lxc_image.SandboxLxcImage.Parameters.ubuntu_release(default=sandbox_lxc_image.UbuntuRelease.TRUSTY)
        resource_type = sandbox_lxc_image.SandboxLxcImage.Parameters.resource_type(default=resources.LXC_CONTAINER.name)
        install_common = sandbox_lxc_image.SandboxLxcImage.Parameters.install_common(default=True)
        custom_repos = sandbox_lxc_image.SandboxLxcImage.Parameters.custom_repos(default="\n".join(utils.CUSTOM_REPOS_TRUSTY))
        custom_packages = sandbox_lxc_image.SandboxLxcImage.Parameters.custom_packages(default=" ".join(CUSTOM_PACKAGES))
        custom_script = sandbox_lxc_image.SandboxLxcImage.Parameters.custom_script(default="\n".join(CUSTOM_SCRIPT))
        custom_attrs = sandbox_lxc_image.SandboxLxcImage.Parameters.custom_attrs(default={"ttl": "inf", "metriqa_jenkins_slave": "knight-trusty"})
