# coding=utf-8
from __future__ import unicode_literals

from sandbox import sdk2
from sandbox.common.types.task import ReleaseStatus
from sandbox.projects.common import binary_task
from sandbox.projects.metrika.admins.metrika_build_binary_task import test_info
from sandbox.projects.metrika.admins.tasks_list import MetrikaTasksList
from sandbox.projects.metrika.utils import CommonParameters, tasks
from sandbox.projects.metrika.utils import parameters
from sandbox.projects.metrika.utils import settings
from sandbox.projects.metrika.utils.base_metrika_task import with_parents, BaseMetrikaTask
from sandbox.projects.metrika.utils.mixins.releasable import ReleasableMixin
from sandbox.projects.metrika.utils.parameters import TrackerIssue, ArcadiaURL
from sandbox.projects.sandbox.deploy_binary_task import DeployBinaryTask
from sandbox.sdk2.service_resources import SandboxTasksBinary


@with_parents
class MetrikaBuildBinaryTask(BaseMetrikaTask, ReleasableMixin):
    class Parameters(CommonParameters):
        description = 'BUILD BINARY'

        arcadia_url = ArcadiaURL('URL Аркадии', required=True, default='arcadia-arc:/#trunk')
        task_type = sdk2.parameters.String('Таска', required=True, choices=parameters.choices(sorted(tasks.TASKS)))

        ticket = TrackerIssue()

        release_branch = sdk2.parameters.String(
            'Ветка релиза', required=True, default=ReleaseStatus.TESTING,
            choices=parameters.choices([ReleaseStatus.STABLE, ReleaseStatus.TESTING, ReleaseStatus.UNSTABLE])
        )

        test = sdk2.parameters.Bool('Тестирование', default=True)

        _binary = binary_task.binary_release_parameters_list(stable=True)

    def on_save(self):
        self.Parameters.description = self.Parameters.task_type

    def on_enqueue(self):
        self.Context.arcadia_url = self.Parameters.arcadia_url.format(author=self.author, ticket=self.Parameters.ticket)

    def before_test_task_enqueued(self, subtask):
        subtask.Parameters.binary_executor_release_type = 'custom'
        subtask.Requirements.tasks_resource = self.Context.test_binary
        subtask.save()

    def on_execute(self):
        self.Parameters.tags = [self.Parameters.task_type]
        if not self.Context.task_path:
            self.Context.task_path = MetrikaTasksList.get_all_tasks(self.Context.arcadia_url).get(self.Parameters.task_type)
            if not self.Context.task_path:
                raise ValueError('Unknown task type: {}'.format(self.Parameters.task_type))

        self.Context.deploy_task = self.run_subtasks([(
            DeployBinaryTask,
            {
                DeployBinaryTask.Parameters.arcadia_url.name: self.Context.arcadia_url,
                DeployBinaryTask.Parameters.target.name: self.Context.task_path,
                DeployBinaryTask.Parameters.attrs.name:
                    {
                        'task_type': self.Parameters.task_type,
                        'owner': settings.owner,
                        'sync_upload_to_mds': True
                    },
                DeployBinaryTask.Parameters.arc_oauth_token.name: 'sec-01egj9vm4tcnffae8qr86sq928',
                DeployBinaryTask.Parameters.release_ttl.name: 30
            }
        )])[0]

        with self.memoize_stage.release(commit_on_entrance=False):
            ReleasableMixin.on_release(self, {'release_status': self.Parameters.release_branch})
            self.set_info(
                '<a href="https://sandbox.yandex-team.ru/tasks?children=true&hidden=false&type={}&limit=20&created=14_days">Задачи</a>'.format(
                    self.Parameters.task_type
                ),
                do_escape=False
            )

        if self.Parameters.test and self.Parameters.task_type in test_info.TESTS:
            self.Context.test_binary = SandboxTasksBinary.find(task_id=self.Context.deploy_task).first().id
            params = {getattr(k, 'name', k): v for k, v in test_info.TESTS[self.Parameters.task_type].items()}
            params.update({'show_secret_admin_params': True, 'binary_executor_release_type': 'none'})
            self.run_subtasks(
                [(self.Parameters.task_type, params)],
                wait=False, pass_tasks_resource=False, before_subtask_enqueued=self.before_test_task_enqueued
            )

    @property
    def releasable_tasks(self):
        # find doesnt cache
        return list(sdk2.Task.find(id=self.Context.deploy_task).limit(0))
