# coding=utf-8
from sandbox.projects.metrika.utils.pipeline.contextable import Contextable


class Source(Contextable):
    def __init__(self, storage=None):
        super(Source, self).__init__(storage)

    @property
    def key(self):
        return self.original_id

    @property
    def id(self):
        return self._default_getter()

    @id.setter
    def id(self, value):
        self._default_setter(value)

    @property
    def original_id(self):
        return self._default_getter()

    @original_id.setter
    def original_id(self, value):
        self._default_setter(value)

    @property
    def original_name(self):
        return self._default_getter()

    @original_name.setter
    def original_name(self, value):
        self._default_setter(value)

    @property
    def name(self):
        return self._default_getter()

    @name.setter
    def name(self, value):
        self._default_setter(value)

    @property
    def database(self):
        return self._default_getter()

    @database.setter
    def database(self, value):
        self._default_setter(value)

    @property
    def backup_id(self):
        return self._default_getter()

    @backup_id.setter
    def backup_id(self, value):
        self._default_setter(value)

    @property
    def backup_operation_id(self):
        return self._default_getter()

    @backup_operation_id.setter
    def backup_operation_id(self, value):
        self._default_setter(value)

    @property
    def is_parallel_backup_operation_detected(self):
        return self._default_getter()

    @is_parallel_backup_operation_detected.setter
    def is_parallel_backup_operation_detected(self, value):
        self._default_setter(value)

    @property
    def restore_operation_id(self):
        return self._default_getter()

    @restore_operation_id.setter
    def restore_operation_id(self, value):
        self._default_setter(value)

    @property
    def endpoint_id(self):
        return self._default_getter()

    @endpoint_id.setter
    def endpoint_id(self, value):
        self._default_setter(value)


class Destination(Contextable):
    def __init__(self, storage=None):
        super(Destination, self).__init__(storage)

    @property
    def key(self):
        return [self.host, self.database]

    @property
    def host(self):
        return self._default_getter()

    @host.setter
    def host(self, value):
        self._default_setter(value)

    @property
    def database(self):
        return self._default_getter()

    @database.setter
    def database(self, value):
        self._default_setter(value)

    @property
    def port(self):
        return self._default_getter()

    @port.setter
    def port(self, value):
        self._default_setter(value)

    @property
    def endpoint_id(self):
        return self._default_getter()

    @endpoint_id.setter
    def endpoint_id(self, value):
        self._default_setter(value)


class Link(Contextable):
    def __init__(self, storage=None):
        super(Link, self).__init__(storage)

    @property
    def source_key(self):
        return self._default_getter()

    @source_key.setter
    def source_key(self, value):
        self._default_setter(value)

    @property
    def destination_key(self):
        return self._default_getter()

    @destination_key.setter
    def destination_key(self, value):
        self._default_setter(value)

    @property
    def transfer_id(self):
        return self._default_getter()

    @transfer_id.setter
    def transfer_id(self, value):
        self._default_setter(value)

    @property
    def activate_operation_id(self):
        return self._default_getter()

    @activate_operation_id.setter
    def activate_operation_id(self, value):
        self._default_setter(value)


class State(Contextable):
    def __init__(self, storage=None):
        super(State, self).__init__(storage)
        if storage is None:
            self.clear()

    def clear(self):
        self._sources = []
        self._destinations = []
        self._links = []

    @property
    def maas_host(self):
        return self._default_getter()

    @maas_host.setter
    def maas_host(self, value):
        self._default_setter(value)

    @property
    def config(self):
        return self._default_getter()

    @config.setter
    def config(self, value):
        self._default_setter(value)

    @property
    def maas_instance_id(self):
        return self._default_getter()

    @maas_instance_id.setter
    def maas_instance_id(self, value):
        self._default_setter(value)

    @property
    def target_timestamp(self):
        return self._default_getter()

    @target_timestamp.setter
    def target_timestamp(self, value):
        self._default_setter(value)

    @property
    def _sources(self):
        return self._default_getter()

    @_sources.setter
    def _sources(self, value):
        self._default_setter(value)

    @property
    def _destinations(self):
        return self._default_getter()

    @_destinations.setter
    def _destinations(self, value):
        self._default_setter(value)

    @property
    def _links(self):
        return self._default_getter()

    @_links.setter
    def _links(self, value):
        self._default_setter(value)

    @property
    def sources(self):
        return [Source(state) for state in self._sources]

    def add_source(self, value):
        self._sources.append(value.state)

    @property
    def destinations(self):
        return [Destination(state) for state in self._destinations]

    def add_destination(self, value):
        self._destinations.append(value.state)

    @property
    def links(self):
        return [Link(state) for state in self._links]

    def get_source_for_link(self, link):
        return next(s for s in self.sources if s.key == link.source_key)

    def get_destination_for_link(self, link):
        return next(d for d in self.destinations if d.key == link.destination_key)

    def add_link(self, value):
        self._links.append(value.state)
