# coding=utf-8
from sandbox import sdk2
from sandbox.projects.common import binary_task
from sandbox.projects.metrika.utils import CommonParameters
from sandbox.projects.metrika.utils.base_metrika_task import with_parents, BaseMetrikaTask
from sandbox.projects.metrika.utils.mixins.juggler_reporter import JugglerReporterMixin


@with_parents
class MetrikaRestartSaltMaster(BaseMetrikaTask, JugglerReporterMixin):
    class Parameters(CommonParameters):
        wait_seconds = sdk2.parameters.Integer('wait_seconds', default=900)

        _binary = binary_task.binary_release_parameters_list(stable=True)

    def on_execute(self):
        from metrika.pylib.deploy.client import DeployAPI
        deploy_api = DeployAPI(token=sdk2.yav.Secret('sec-01cq6h07rwpqmqzb15y08jbs5q').data()['yp_token'])
        deploy_api.stage.restart_workload(
            stage='salt-master', comment='Restart from scheduler to decrease mem usage',
            wait_seconds=self.Parameters.wait_seconds, check_result=True,
        )
