import sandbox.sdk2 as sdk2
import sandbox.projects.common.binary_task as binary_task

import sandbox.projects.metrika.utils.base_metrika_task as bmt
import sandbox.projects.metrika.utils.settings as settings
import sandbox.projects.metrika.utils as utils


@bmt.with_parents
class MetrikaMiNamespacesSync(bmt.BaseMetrikaTask):
    class Parameters(utils.CommonParameters):
        url = sdk2.parameters.String(
            'URL',
            required=True,
            default='https://mi.mtrs.yandex-team.ru/api/awacs/internal/refresh_namespaces',
        )
        token = sdk2.parameters.YavSecret(
            'Token',
            required=True,
            default='{}#admin_oauth_token'.format(settings.rma_yav_uuid),
        )
        _binary = binary_task.binary_release_parameters_list(stable=True)

    def on_execute(self):
        import metrika.pylib.http as http

        secret = self.Parameters.token.data()
        token = secret[self.Parameters.token.default_key]

        http.request(
            url=self.Parameters.url,
            method='POST',
            oauth_token=token,
            timeout=(5, 300),
            retry_if_http_error=False,
        )
