# coding=utf-8

from sandbox import sdk2
from sandbox.common.types import resource
from sandbox.projects.common import binary_task
from sandbox.projects.metrika.admins import base_metrika_tests, base_metrika_tests_run
from sandbox.projects.metrika.core import base_metrika_core_tests_run, metrika_core_arcadia_tests_run
from sandbox.projects.metrika.core.appmetrica_core_b2b_scenario_execute import tests_helper
from sandbox.projects.metrika.core.metrika_core_arcadia_tests_run import view
from sandbox.projects.metrika.core.utils import metrika_core_tests_helper
from sandbox.projects.metrika.utils import base_metrika_task, parameters as metrika_parameters, resource_types, settings
from sandbox.sdk2 import helpers, parameters


@base_metrika_task.with_parents
class AppMetricaCoreB2bScenarioExecute(base_metrika_core_tests_run.BaseMetrikaCoreTestsRun):
    """
    Прогон сценария B2B тестов демонов Движка АппМетрики
    """
    name = "APPMETRICA_CORE_B2B_SCENARIO_EXECUTE"

    class Parameters(base_metrika_tests.BaseMetrikaTests.Parameters):
        description = "Прогон сценария B2B тестов демонов Движка АппМетрики"

        arcadia_url = metrika_parameters.ArcadiaURL("URL Аркадии", required=True, default="arcadia-arc:/#trunk")

        daemons = parameters.Dict("Демона")

        clickhouse_resource = parameters.Resource("Ресурс с ClickHouse", required=False, resource_type=resource_types.MetrikaClickhouseBinary)

        local_daemons = parameters.Bool("Запускать конвейер с демонами из ветки (не использовать ресурсы)", required=True, default=False)

        local_configs = parameters.Bool("Запускать конвейер с конфигами из ветки (не использовать ресурсы)", required=True, default=False)

        fast = parameters.Bool("Запускать быстрый конвейер (используется урезанный Исток)", required=True, default=False)

        _binary = binary_task.binary_release_parameters_list(stable=True)

    @base_metrika_task.exclude_parents(base_metrika_tests_run.BaseMetrikaTestsRun)
    def on_execute(self):
        with helpers.ProgressMeter("Versions"):
            self._get_packages_versions()
        with helpers.ProgressMeter("Run tests"):
            self._run_tests()
        with helpers.ProgressMeter("Analyze Results"):
            self._analyze_results()

    def shortcut(self):
        return "Arcadia B2B"

    def project_name(self):
        return "appmetrica-core-tests-b2b-acradia"

    def report_description(self):
        return "Протокол аркадийных B2B тестов Движка АппМетрики"

    def _get_view_model(self):
        return view.ViewModel(self)

    def _get_packages_versions(self):
        with self.memoize_stage.get_versions(commit_on_entrance=False):
            self.Context.daemons_versions = tests_helper.TestsHelper.get_packages_versions(self.Parameters.arcadia_url, self.Parameters.daemons)
            self.Context.daemons_resources = {}
            for daemon, version in self.Context.daemons_versions.items():
                self.Context.daemons_resources[daemon] = resource_types.BaseMetrikaBinaryResource.find(
                    owner=settings.owner, state=resource.State.READY,
                    attrs={
                        "resource_name": daemon,
                        "resource_version": version
                    }
                ).first().id
            self.Context.configs_resources = {}
            for daemon, version in self.Context.daemons_versions.items():
                self.Context.configs_resources[daemon + "-config"] = resource_types.BaseMetrikaConfigResource.find(
                    owner=settings.owner, state=resource.State.READY,
                    attrs={
                        "resource_name": daemon,
                        "resource_version": version
                    }
                ).first().id

    def _run_tests(self):
        daemons_flags = " ".join("-D{}={}".format(daemon, resource_id) for daemon, resource_id in sorted(self.Context.daemons_resources.items()))
        configs_flags = " ".join("-D{}={}".format(config, resource_id) for config, resource_id in sorted(self.Context.configs_resources.items()))
        clickhouse_flag = "-DUSE_SB_CH={}".format(self.Parameters.clickhouse_resource.id) if self.Parameters.clickhouse_resource else ""
        local_daemons_flag = "-Dlocal-daemons" if self.Parameters.local_daemons else ""
        local_configs_flag = "-Dlocal-configs" if self.Parameters.local_configs else ""
        fast_flag = "-Dfast" if self.Parameters.fast else ""
        self.Context.test_task = self.run_subtasks((
            metrika_core_arcadia_tests_run.MetrikaCoreArcadiaTestsRun,
            dict(
                checkout_arcadia_from_url=self.Parameters.arcadia_url,
                targets="metrika/core/b2b/app/scenario",
                fail_task_on_test_failure=False,
                failed_tests_cause_error=True,
                report_startrek=self.Parameters.report_startrek,
                issue_key=self.Parameters.issue_key,
                tests_type="B2B",
                definition_flags=" ".join([daemons_flags, configs_flags, clickhouse_flag, local_daemons_flag, local_configs_flag, fast_flag]),
                arts="metrika/core/b2b/app/scenario/test-results/py3test/testing_out_stuff/output",
                report_ttl=self.Parameters.report_ttl,
                allure_report_ttl=self.Parameters.report_ttl,
                result_rt=metrika_core_tests_helper.AppMetricaCoreOutputB2bTestData.name,
                result_rd="AppMetrica Core B2B tests output data",
                result_attrs=dict(
                    arcadia_b2b=True,
                    task_release=tests_helper.TestsHelper._get_task_release(self),
                    **self.Context.daemons_versions
                ),
                result_single_file=True,
                test_filters="__init__.py::test_scenario"
            )
        ))[0]
        self.Parameters.report_resource = sdk2.Task[self.Context.test_task].Parameters.report_resource
        self.Parameters.test_results = sdk2.Task[self.Context.test_task].Parameters.test_results
