# coding=utf-8

from sandbox.projects.common import binary_task
from sandbox.projects.metrika import utils
from sandbox.projects.metrika.core.metrika_core_b2b_configs_release import release_helper
from sandbox.projects.metrika.utils import base_metrika_task
from sandbox.projects.metrika.utils.mixins import releasable
from sandbox.projects.metrika.utils.parameters import hide
from sandbox.projects.metrika.utils.pipeline import pipeline
from sandbox.sdk2 import parameters

REPORT_TTL = 30


@base_metrika_task.with_parents
class MetrikaCoreB2bConfigsRelease(pipeline.PipelineBaseTask, releasable.ReleasableMixin):
    """
    Релиз шаблонов конфигов демонов Движка Метрики
    """
    name = "METRIKA_CORE_B2B_CONFIGS_RELEASE"

    class Context(pipeline.PipelineBaseTask.Context):
        build_configs_task_ids = []
        run_test_tasks_ids = []

    class Parameters(utils.CommonParameters):
        description = "Релиз шаблонов конфигов демонов Движка Метрики"

        with parameters.Group("Настройки этапа сборки") as build_configs_group:
            arcadia_url = parameters.ArcadiaUrl(
                "URL Аркадии", required=True, default="arcadia-arc:/#trunk",
                description="Ветка или коммит, из которой будут собраны ресурсы с шаблонами конфигов демонов."
            )

            daemon_list = parameters.List(
                "Список демонов", required=True,
                description="Демона Движка Метрики, сборка ресурсов с шаблонами конфигов которых будет осуществлено."
            )

        with parameters.Group("Настройки этапа тестирования") as run_tests_group:
            run_tests = parameters.Bool(
                "Тестирование", required=True, default=True,
                description="Запускать ли тесты."
            )

        _binary = hide(binary_task.binary_release_parameters_list(stable=True))

    def on_save(self):
        release_helper.ReleaseHelper.check_daemons(self, self.Parameters.daemon_list)

    def on_enqueue(self):
        release_helper.ReleaseHelper.update_description(self, self.real_author, self.Parameters.daemon_list, self.Parameters.arcadia_url)

        release_helper.ReleaseHelper.set_build_description(self)

    def create_stages(self):
        return [
            (self.stage_build_configs, "Сборка шаблонов конфигов"),
            (self.stage_run_tests, "Тесты"),
        ]

    def stage_build_configs(self):
        build_configs_tasks = release_helper.ReleaseHelper.get_build_configs_tasks(
            self, self.real_author, self.Parameters.daemon_list, self.Parameters.arcadia_url
        )

        self.run_subtasks(build_configs_tasks, subtasks_variable=self.Context.build_configs_task_ids)

    def stage_run_tests(self):
        if self.Parameters.run_tests:
            run_test_tasks = release_helper.ReleaseHelper.get_run_tests_tasks(
                self, self.Parameters.daemon_list, self.Parameters.arcadia_url, REPORT_TTL
            )
            self.run_subtasks(run_test_tasks, subtasks_variable=self.Context.run_test_tasks_ids)
        else:
            self.set_info("Запуска тестов не будет.")
