# coding=utf-8
import logging

from sandbox.projects.common import constants
from sandbox.projects.common.build import YaPackage2
from sandbox.projects.common.build.ya_package_config import consts
from sandbox.projects.metrika.admins import programs_list
from sandbox.projects.metrika.core import appmetrica_core_b2b_tests_run, metrika_core_b2b_tests_run
from sandbox.projects.metrika.core.appmetrica_core_b2b_scenario_execute import tests_helper as appmetrica_tests_helper
from sandbox.projects.metrika.core.metrika_core_b2b_scenario_execute import tests_helper as metrika_tests_helper
from sandbox.projects.metrika.core.utils import metrika_core_helper
from sandbox.projects.metrika.utils import resource_types, settings
from sandbox.projects.metrika.utils.task_types import ya_package

logger = logging.getLogger("release-helper")


class ReleaseHelper(metrika_core_helper.MetrikaCoreHelper):

    @staticmethod
    def get_build_configs_tasks(task, author, daemon_list, arcadia_url):
        task.Context.all_programs = metrika_core_helper.MetrikaCoreHelper.get_all_programs(arcadia_url, "metrika/core")

        metrika_core_helper.MetrikaCoreHelper._check_buildability(task.Context.all_programs, daemon_list)

        daemons_with_configs = [daemon for daemon in daemon_list if programs_list.CONFIG_JSON in task.Context.all_programs.get(daemon)]

        build_configs_tasks = []

        for daemon in daemon_list:
            if daemon in daemons_with_configs:
                build_configs_tasks.append((ya_package.MetrikaYaPackage, {
                    "description": metrika_core_helper.MetrikaCoreHelper._get_description("Сборка шаблонов конфигов для тестов демонов Движка Метрики ", author, [daemon], arcadia_url),
                    YaPackage2.YaPackage2Parameters.checkout_arcadia_from_url: arcadia_url,
                    YaPackage2.YaPackage2Parameters.build_type: constants.PROFILE_BUILD_TYPE,
                    YaPackage2.YaPackage2Parameters.custom_version: ReleaseHelper.get_stable_version(daemon),
                    YaPackage2.YaPackage2Parameters.run_tests: False,
                    YaPackage2.YaPackage2Parameters.run_long_tests: False,
                    YaPackage2.YaPackage2Parameters.clear_build: True,
                    YaPackage2.YaPackage2Parameters.semi_clear_build: True,
                    YaPackage2.YaPackage2Parameters.yp_token_vault: settings.yp_token,
                    YaPackage2.YaPackage2Parameters.package_type: consts.PackageType.TARBALL.value,
                    YaPackage2.YaPackage2Parameters.packages: task.Context.all_programs.get(daemon).get(programs_list.CONFIG_JSON),
                    YaPackage2.YaPackage2Parameters.resource_type: resource_types.BaseMetrikaConfigResource.name,
                    YaPackage2.YaPackage2Parameters.release_to_ya_deploy: False,
                }))

        return build_configs_tasks

    @staticmethod
    def get_run_tests_tasks(task, daemon_list, arcadia_url, report_ttl):
        task.Context.appmetrica_daemons_under_arcadia_b2b = appmetrica_tests_helper.TestsHelper.get_daemons_under_arcadia_b2b()
        task.Context.metrika_daemons_under_arcadia_b2b = metrika_tests_helper.TestsHelper.get_daemons_under_arcadia_b2b()

        run_tests_tasks = []
        run_appmetrica_b2b = False
        run_metrika_b2b = False

        for daemon in daemon_list:
            if daemon in task.Context.appmetrica_daemons_under_arcadia_b2b:
                run_appmetrica_b2b = True
            if daemon in task.Context.metrika_daemons_under_arcadia_b2b:
                run_metrika_b2b = True

        description = "Тесты изменений в шаблонах конфигов из {}".format(arcadia_url)

        if run_appmetrica_b2b:
            run_tests_tasks.append((appmetrica_core_b2b_tests_run.AppMetricaCoreB2bTestsRun, {
                appmetrica_core_b2b_tests_run.AppMetricaCoreB2bTestsRun.Parameters.description: description,
                appmetrica_core_b2b_tests_run.AppMetricaCoreB2bTestsRun.Parameters.arcadia_url: arcadia_url,
                appmetrica_core_b2b_tests_run.AppMetricaCoreB2bTestsRun.Parameters.force_test_scenario: True,
                appmetrica_core_b2b_tests_run.AppMetricaCoreB2bTestsRun.Parameters.local_configs: True,
                appmetrica_core_b2b_tests_run.AppMetricaCoreB2bTestsRun.Parameters.report_ttl: report_ttl,
                appmetrica_core_b2b_tests_run.AppMetricaCoreB2bTestsRun.Parameters.fail_task_on_test_failure: True
            }))

        if run_metrika_b2b:
            run_tests_tasks.append((metrika_core_b2b_tests_run.MetrikaCoreB2bTestsRun, {
                metrika_core_b2b_tests_run.MetrikaCoreB2bTestsRun.Parameters.description: description,
                metrika_core_b2b_tests_run.MetrikaCoreB2bTestsRun.Parameters.arcadia_url: arcadia_url,
                metrika_core_b2b_tests_run.MetrikaCoreB2bTestsRun.Parameters.force_test_scenario: True,
                metrika_core_b2b_tests_run.MetrikaCoreB2bTestsRun.Parameters.local_configs: True,
                metrika_core_b2b_tests_run.MetrikaCoreB2bTestsRun.Parameters.report_ttl: report_ttl,
                metrika_core_b2b_tests_run.MetrikaCoreB2bTestsRun.Parameters.fail_task_on_test_failure: True
            }))

        return run_tests_tasks
