# coding=utf-8

from sandbox import sdk2
from sandbox.projects.common import binary_task
from sandbox.projects.metrika import utils
from sandbox.projects.metrika.core.metrika_core_b2b_scenario_output_upload import upload_helper
from sandbox.projects.metrika.core.utils import metrika_core_tests_helper
from sandbox.projects.metrika.utils.base_metrika_task import base_metrika_task
from sandbox.projects.metrika.utils.mixins import console

YT_CLUSTERS = [
    "hahn",
    "arnold"
]


@base_metrika_task.with_parents
class MetrikaCoreB2BScenarioOutputUpload(base_metrika_task.BaseMetrikaTask, console.BaseConsoleMixin):
    name = "METRIKA_CORE_B2B_SCENARIO_OUTPUT_UPLOAD"

    class Requirements(utils.requirements.MetrikaLargeRequirements):
        privileged = True

    class Parameters(utils.CommonParameters):
        description = "Upload output of B2B scenario to YT"

        resource = sdk2.parameters.Resource(
            "B2B output resource",
            required=True,
            resource_type=[
                metrika_core_tests_helper.MetrikaCoreOutputB2bTestData,
                metrika_core_tests_helper.AppMetricaCoreOutputB2bTestData
            ]
        )

        yt_cluster = sdk2.parameters.String(
            "YT cluster", default=YT_CLUSTERS[0], choices=[(item, item) for item in YT_CLUSTERS]
        )
        ttl = sdk2.parameters.Integer("TTL in days", default=7)

        with sdk2.parameters.Group("Secret parameters") as secret_block:
            yt_token = sdk2.parameters.YavSecretWithKey("YT token", default="sec-01e96bqthwbsdczcx7mn3mhp3f#token")

        _binary = binary_task.binary_release_parameters_list(stable=True)

    def on_execute(self):
        with sdk2.helpers.ProgressMeter("Unzip resource"):
            self._unzip_resource()
        with sdk2.helpers.ProgressMeter("Install environment packages"):
            self._install_environment_packages()
        with sdk2.helpers.ProgressMeter("Configure Clickhouse"):
            self._configure_clickhouse()
        with sdk2.helpers.ProgressMeter("Dump"):
            self._dump()
        with sdk2.helpers.ProgressMeter("Upload to YT"):
            self._upload_to_yt()
        self._add_link()

    def _unzip_resource(self):
        upload_helper.UploadHelper.unzip_resource(self.Parameters.resource, self.wd())

    def _install_environment_packages(self):
        upload_helper.UploadHelper.install_environment_packages(self)

    def _configure_clickhouse(self):
        upload_helper.UploadHelper._configure_clickhouse(self, data_dir=self.wd("output/clickhouse"))

    def _dump(self):
        upload_helper.UploadHelper.dump(self)

    def _upload_to_yt(self):
        upload_helper.UploadHelper.upload_to_yt(self)

    def _add_link(self):
        upload_helper.UploadHelper.add_link(self)
