# coding=utf-8
import os

from sandbox.projects.metrika.core.utils import metrika_core_tests_helper

YT_PATH = "//home/metrika/tests_results"


class UploadHelper(metrika_core_tests_helper.MetrikaCoreTestsHelper):
    @staticmethod
    def yt_client(task):
        from yt import wrapper
        return wrapper.YtClient(proxy=task.Parameters.yt_cluster,
                                token=task.Parameters.yt_token.value())

    @staticmethod
    def dump(task):
        from_path = task.wd("output/clickhouse/data")
        metrika_core_tests_helper.MetrikaCoreTestsHelper.shell(task, ["mkdir", "-p", "dump"])

        for database in os.listdir(from_path):
            database_path = os.path.join("dump", database)
            metrika_core_tests_helper.MetrikaCoreTestsHelper.shell(task, ["mkdir", "-p", database_path])
            for table in os.listdir(os.path.join(from_path, database)):
                table_path = os.path.join(database_path, "{}.tskv".format(table))
                metrika_core_tests_helper.MetrikaCoreTestsHelper.script(
                    task,
                    "clickhouse-client --query='select * from {}.{} format TSKV' > {}".format(database, table, table_path)
                )

    @staticmethod
    def upload_to_yt(task):
        yt_client = UploadHelper.yt_client(task)
        resource_path = "{}/{}".format(YT_PATH, task.Parameters.resource.id)
        yt_client.create("map_node", resource_path, ignore_existing=True)

        UploadHelper.upload_clickhouse_to_yt(task, resource_path)
        UploadHelper.upload_files_to_yt(task, resource_path)

        yt_client.set_attribute(resource_path, "expiration_timeout", 1000 * 60 * 60 * 24 * task.Parameters.ttl)

    @staticmethod
    def handler(paths, task):
        yt_client = UploadHelper.yt_client(task)
        yt_path = paths[0]
        local_path = paths[1]

        with open(local_path) as file:
            yt_client.write_table(
                yt_path,
                file,
                format="dsv",
                raw=True
            )

    @staticmethod
    def upload_clickhouse_to_yt(task, path):
        from metrika.pylib import utils as pylib_utils

        yt_client = UploadHelper.yt_client(task)

        clickhouse_path = "{}/clickhouse".format(path)
        yt_client.create("map_node", clickhouse_path, ignore_existing=True)
        tables_pair_paths = []

        for directory in os.listdir("dump"):
            yt_directory_path = "{}/{}".format(clickhouse_path, directory)
            yt_client.create("map_node", yt_directory_path, ignore_existing=True)
            directory_path = os.path.join("dump", directory)

            for file in os.listdir(directory_path):
                tables_pair_paths.append((
                    "{}/{}".format(yt_directory_path, os.path.splitext(file)[0]),
                    os.path.join(directory_path, file)
                ))

        pylib_utils.parallel(
            UploadHelper.handler,
            args=[task],
            queue=tables_pair_paths,
            thread_count=32,
            join_timeout=1200
        )

    @staticmethod
    def upload_files_to_yt(task, path):
        from metrika.pylib import utils as pylib_utils

        yt_client = UploadHelper.yt_client(task)

        files_path = "{}/files".format(path)
        yt_client.create("map_node", files_path, ignore_existing=True)
        files_pair_paths = []

        for directory in os.listdir(task.wd("output/files")):
            yt_directory_path = "{}/{}".format(files_path, directory)
            yt_client.create("map_node", yt_directory_path, ignore_existing=True)
            directory_path = os.path.join(task.wd("output/files"), directory)

            for file in os.listdir(directory_path):
                if file.startswith("dumped-"):
                    files_pair_paths.append((
                        "{}/{}".format(yt_directory_path, os.path.splitext(file)[0]),
                        os.path.join(directory_path, file)
                    ))

        pylib_utils.parallel(
            UploadHelper.handler,
            args=[task],
            queue=files_pair_paths,
            thread_count=16,
            join_timeout=1200
        )

    @staticmethod
    def add_link(task):
        task.set_info("<a class='link link_new_tab' href='{}'>Каталог в YT</a>".format(
            "https://yt.yandex-team.ru/{}/navigation?path={}".format(
                task.Parameters.yt_cluster,
                "{}/{}".format(YT_PATH, task.Parameters.resource.id)
            )
        ), do_escape=False)
