# coding=utf-8

from sandbox.projects.metrika.admins import metrika_forsaken_stands_remove
from sandbox.projects.metrika.core import metrika_core_test_stand_remove
from sandbox.projects.metrika.utils import base_metrika_task


@base_metrika_task.with_parents
class MetrikaCoreForsakenStandsRemove(metrika_forsaken_stands_remove.MetrikaForsakenStandsRemove):
    """
    Удаление устаревших тестовых стендов Движка Метрики
    """

    class Parameters(metrika_forsaken_stands_remove.MetrikaForsakenStandsRemove.Parameters):
        description = "Удаление устаревших тестовых стендов Движка Метрики"

    def list_stands(self):
        return [stand.get("id") for stand in self.deploy_client.stage.list_project_stages("metrika-core-autobetas")]

    def delete_stand(self, stand):
        return (
            metrika_core_test_stand_remove.MetrikaCoreTestStandRemove,
            dict(
                description="Forsaken " + stand,
                stage_name=stand
            )
        )
