# coding=utf-8

from sandbox.projects.common import binary_task
from sandbox.projects.metrika import utils
from sandbox.projects.metrika.core.metrika_core_source_refresh import source_helper
from sandbox.projects.metrika.utils import base_metrika_task, resource_types, settings
from sandbox.projects.metrika.utils.mixins import console
from sandbox.sdk2 import parameters, ssh


@base_metrika_task.with_parents
class MetrikaCoreSourceRefresh(base_metrika_task.BaseMetrikaTask, console.BaseConsoleMixin):
    """
    Подготовка Истока Движка Метрики
    """

    class Parameters(utils.CommonParameters):
        description = "Подготовка Истока Движка Метрики"

        hostname = parameters.String("Машинка для тестовых данных", required=True, default="source.vla.yp-c.yandex.net",
                                     description="FQDN хоста, на который будет подвезен ресурс с тестовыми данными")

        resource_type = parameters.String("Тип ресурса", required=True, default=resource_types.MetrikaCoreB2bTestsData.name,
                                          choices=[("Metrika", resource_types.MetrikaCoreB2bTestsData.name), ("AppMetrica", resource_types.AppmetricaCoreB2bTestsData.name)])

        resource_attribute = parameters.String("Атрибут ресурса", required=True, default="stable", choices=[("stable", "stable"), ("testing", "testing")])

        dump_yt = parameters.Bool("Скачать данные из YT", required=True, default=False, description="Обновить ли LB данные содержимым YT таблиц")

        with parameters.Group("Secret parameters") as secret_block:
            yt_token = parameters.YavSecretWithKey("YT token", default="{}#yt-token".format(settings.yav_uuid))

        _binary = binary_task.binary_release_parameters_list(stable=True)

    @property
    def yt_client(self):
        from yt import wrapper
        return wrapper.YtClient(
            proxy="hahn", token=self.Parameters.yt_token.value(),
            config={"read_parallel": {"enable": True, "max_thread_count": 64}}
        )

    def on_execute(self):
        with ssh.Key(self, settings.owner, settings.ssh_key):
            source_helper.SourceHelper.prepare(self, self.Parameters.hostname)
