# coding=utf-8
from sandbox.projects.sandbox import remote_copy_resource

from sandbox import sdk2
from sandbox.projects.common import binary_task
from sandbox.projects.metrika import utils
from sandbox.projects.metrika.core import utils as core_utils
from sandbox.projects.metrika.utils import base_metrika_task
from sandbox.projects.metrika.utils import resource_types
from sandbox.projects.metrika.utils.base_metrika_task import BaseMetrikaTask
from sandbox.sdk2 import parameters


@base_metrika_task.with_parents
class MetrikaCoreSourceUpdate(BaseMetrikaTask):
    """
    Обновление Истока Движка Метрики
    """

    class Context(sdk2.Context):
        torrent_id = 0

    class Parameters(utils.CommonParameters):
        description = "Обновление Истока Движка Метрики"

        hostname = parameters.String("Машинка с тестовыми данными", required=True, default="source.vla.yp-c.yandex.net",
                                     description="FQDN хоста, с которого будет производиться обновление ресурса")

        resource_type = parameters.String("Тип ресурса", required=True, default=resource_types.MetrikaCoreB2bTestsData.name,
                                          choices=[("Metrika", resource_types.MetrikaCoreB2bTestsData.name), ("AppMetrica", resource_types.AppmetricaCoreB2bTestsData.name)])

        resource_attribute = parameters.String("Атрибут ресурса", required=True, default="stable", choices=[("stable", "stable"), ("testing", "testing")])

        _binary = binary_task.binary_release_parameters_list(stable=True)

    def on_execute(self):
        self.prepare_torrent()
        self.remote_copy_resource()

    def prepare_torrent(self):
        with self.memoize_stage.stage_prepare_torrent(commit_on_entrance=False):
            if self.Parameters.resource_type == resource_types.AppmetricaCoreB2bTestsData.name:
                core_utils.execute_remote_script(self, self.Parameters.hostname, utils.read_sources_file("prepare_appmetrica_test_data.sh"))
                self.Context.torrent_id = core_utils.get_remote_script_output(self, self.Parameters.hostname, "cd /tmp; sky share data.tar.gz")
            if self.Parameters.resource_type == resource_types.MetrikaCoreB2bTestsData.name:
                core_utils.execute_remote_script(self, self.Parameters.hostname, utils.read_sources_file("prepare_metrika_test_data.sh"))
                self.Context.torrent_id = core_utils.get_remote_script_output(self, self.Parameters.hostname, "cd /tmp; sky share mnt2.tar.gz")

    def remote_copy_resource(self):
        params = {
            "resource_type": self.Parameters.resource_type,
            remote_copy_resource.RemoteCopyResource.FileProtocol.name: "skynet",
            remote_copy_resource.RemoteCopyResource.FileName.name: self.Context.torrent_id,
            remote_copy_resource.RemoteCopyResource.ResAttrs.name: "ttl=365,backup_task=True,share=True,use={}".format(self.Parameters.resource_attribute)
        }

        if self.Parameters.resource_type == resource_types.AppmetricaCoreB2bTestsData.name:
            params.update({
                "description": "Данные для B2B тестов Движка АппМетрики",
                remote_copy_resource.RemoteCopyResource.ResName.name: "mobmet"
            })
        if self.Parameters.resource_type == resource_types.MetrikaCoreB2bTestsData.name:
            params.update({
                "description": "Данные для B2B тестов Движка Метрики",
                remote_copy_resource.RemoteCopyResource.ResName.name: "mnt2"
            })

        self.run_subtasks([(remote_copy_resource.RemoteCopyResource, params)])
