from sandbox import sdk2
from sandbox.common.types import resource as ctr
from sandbox.projects import resource_types
from sandbox.projects.common import binary_task
from sandbox.projects.common.decorators import retries
from sandbox.projects.metrika.utils import CommonParameters, settings
from sandbox.projects.metrika.utils.base_metrika_task import with_parents, BaseMetrikaTask
from sandbox.projects.metrika.utils.mixins.console import BaseConsoleMixin
from sandbox.projects.metrika.utils.mixins.dyn_resource import DynResourceMixin
from sandbox.projects.metrika.utils.mixins.juggler_reporter import JugglerReporterMixin
from sandbox.projects.metrika.utils.resource_types import METRIKA_RELEASERS


class MetrikaAllGeo(sdk2.Resource):
    any_arch = True
    auto_backup = True
    restart_policy = ctr.RestartPolicy.DELETE
    releasable = True
    releasers = METRIKA_RELEASERS


@with_parents
class MetrikaUploadAllGeo(BaseMetrikaTask, JugglerReporterMixin, DynResourceMixin, BaseConsoleMixin):
    RESOURCE_COUNT = 3

    class Parameters(CommonParameters):
        dict_checker_binary = sdk2.parameters.LastResource(
            'dictionary-checker', required=True, resource_type=resource_types.OTHER_RESOURCE, owner=settings.owner,
            attrs=dict(program='dictionary-checker')
        )
        _binary = binary_task.binary_release_parameters_list(stable=True)

    @retries(3)
    def on_execute(self):
        binary = sdk2.ResourceData(self.Parameters.dict_checker_binary)

        res_path = self.wd_path('geo')
        res_path.mkdir(parents=True, exist_ok=True)
        self._execute_script("""
            wget -O tmp_wget 'http://geoexport.yandex.ru/?types=_all_&fields=id,parent_id,type,population' && tail -n+2 tmp_wget > {path}/regions_hierarchy.txt
            wget -O tmp_wget 'http://geoexport.yandex.ru/?types=_all_&fields=id,parent_id,type,population&new_parents=977:187' && tail -n+2 tmp_wget > {path}/regions_hierarchy_ua.txt
            wget -O tmp_wget 'http://geoexport.yandex.ru/?types=_all_&fields=id,ru_name' && tail -n+2 tmp_wget > {path}/regions_names_ru.txt
            wget -O tmp_wget 'http://geoexport.yandex.ru/?types=_all_&fields=id,uk_name' && tail -n+2 tmp_wget > {path}/regions_names_ua.txt
            wget -O tmp_wget 'http://geoexport.yandex.ru/?types=_all_&fields=id,by_name' && tail -n+2 tmp_wget > {path}/regions_names_by.txt
            wget -O tmp_wget 'http://geoexport.yandex.ru/?types=_all_&fields=id,kz_name' && tail -n+2 tmp_wget > {path}/regions_names_kz.txt
            wget -O tmp_wget 'http://geoexport.yandex.ru/?types=_all_&fields=id,tr_name' && tail -n+2 tmp_wget > {path}/regions_names_tr.txt
            wget -O tmp_wget 'http://geoexport.yandex.ru/?types=_all_&fields=id,en_name' && tail -n+2 tmp_wget > {path}/regions_names_en.txt
        """.format(path=res_path))

        self._execute_shell_and_check([binary.path.as_posix(), 'region_names', res_path.as_posix()])
        for file in ['regions_hierarchy.txt', 'regions_hierarchy_ua.txt']:
            self._execute_shell_and_check([binary.path.as_posix(), 'region_hierarchy', res_path.joinpath(file).as_posix()])

        MetrikaAllGeo(self, 'all_geo', res_path)
