import shutil

from sandbox.projects.ipreg import IPREG_EXPORT

from sandbox import sdk2
from sandbox.common.types.resource import State
from sandbox.common.types import resource as ctr
from sandbox.common.types.task import ReleaseStatus
from sandbox.projects.common import binary_task
from sandbox.projects.metrika.utils import CommonParameters
from sandbox.projects.metrika.utils.base_metrika_task import with_parents, BaseMetrikaTask
from sandbox.projects.metrika.utils.mixins.dyn_resource import DynResourceMixin
from sandbox.projects.metrika.utils.mixins.juggler_reporter import JugglerReporterMixin
from sandbox.projects.metrika.utils.resource_types import METRIKA_RELEASERS
from sandbox.sdk2.vcs import svn


class MetrikaCalcGeo(sdk2.Resource):
    any_arch = True
    auto_backup = True
    restart_policy = ctr.RestartPolicy.DELETE
    releasable = True
    releasers = METRIKA_RELEASERS


@with_parents
class MetrikaUploadCalcGeo(BaseMetrikaTask, JugglerReporterMixin, DynResourceMixin):
    RESOURCE_COUNT = 3

    class Requirements(BaseMetrikaTask.Requirements):
        disk_space = 5 * 1024

    class Parameters(CommonParameters):
        _binary = binary_task.binary_release_parameters_list(stable=True)

    def on_execute(self):
        ipreg_res = IPREG_EXPORT.find(state=State.READY, released=ReleaseStatus.STABLE).first()
        ipreg_res = sdk2.ResourceData(ipreg_res)

        res_path = self.wd_path('geo')
        res_path.mkdir(parents=True)

        geodata_path = res_path.joinpath('geodata')
        geodata_path.mkdir()
        shutil.copy(ipreg_res.path.joinpath('IPREG.detailed').as_posix(), geodata_path.as_posix())
        geodata_path.joinpath('IPv6').mkdir()
        shutil.copy(ipreg_res.path.joinpath('IPv6/IPREG.detailed').as_posix(), geodata_path.joinpath('IPv6').as_posix())

        for file in ['keys.xml', 'keys-old.xml']:
            svn.Arcadia.export('arcadia.yandex.ru:/robots/trunk/clickdaemon-keys/' + file, res_path.as_posix())

        MetrikaCalcGeo(self, 'calc_geo', res_path)
