from sandbox import sdk2
from sandbox.common.types import resource as ctr
from sandbox.projects.common import binary_task
from sandbox.projects.metrika.utils import CommonParameters
from sandbox.projects.metrika.utils.base_metrika_task import BaseMetrikaTask, with_parents
from sandbox.projects.metrika.utils.task_types.ya_make import MetrikaYaMake
from sandbox.projects.metrika.utils.mixins.dyn_resource import DynResourceMixin
from sandbox.projects.metrika.utils.mixins.juggler_reporter import JugglerReporterMixin
from sandbox.projects.metrika.utils.resource_types import METRIKA_RELEASERS


class DeviceNames(sdk2.Resource):
    any_arch = True
    auto_backup = True
    restart_policy = ctr.RestartPolicy.DELETE
    releasable = True
    releasers = METRIKA_RELEASERS


@with_parents
class MetrikaUploadDeviceNames(BaseMetrikaTask, JugglerReporterMixin, DynResourceMixin):
    class Parameters(CommonParameters):
        _binary = binary_task.binary_release_parameters_list(stable=True)

    @property
    def dyn_resources(self):
        return sdk2.Resource.find(task_id=self.Context.build_task, type=DeviceNames).limit(0)

    def on_execute(self):
        self.Context.build_task = self.run_subtasks([(
            MetrikaYaMake,
            dict(
                checkout_arcadia_from_url='arcadia-arc:/#trunk',
                targets='metrika/mobile-core/devices-names/devices_names',
                use_arc_instead_of_aapi=True,
                arts='metrika/mobile-core/devices-names/devices_names/device-names.json',
                result_rd='device_names',
                result_rt=DeviceNames.name,
                result_single_file=True,
            )
        )])[0]
