import os

from sandbox import sdk2
from sandbox.projects.common import binary_task
from sandbox.projects.metrika.utils.resource_types import METRIKA_RELEASERS
from sandbox.projects.metrika.utils import bstr, CommonParameters
from sandbox.projects.metrika.utils.base_metrika_task import with_parents, BaseMetrikaTask
from sandbox.projects.metrika.utils.mixins.dyn_resource import DynResourceMixin
from sandbox.sdk2.vcs import svn

SVN_PATH = 'arcadia.yandex.ru:/robots/trunk/clickdaemon-keys/keys.xml'


class MetrikaKeysXML(sdk2.Resource):
    share = True
    any_arch = True
    releasable = True
    releasers = METRIKA_RELEASERS


@with_parents
class MetrikaShareKeysXML(BaseMetrikaTask, DynResourceMixin):
    config = None
    _resource_file = None
    _resource_data = None
    _resource_type = MetrikaKeysXML
    _resource_file_name = "keys.xml"
    _resource = None

    class Parameters(CommonParameters):
        description = 'Share keys.xml from arcadia.yandex.ru:/robots/trunk/clickdaemon-keys'
        kill_timeout = 600

        with sdk2.parameters.Group("Bishop"):
            bishop_program = sdk2.parameters.String("Bishop program name", default='metrika-share-keysxml')
            bishop_environment = sdk2.parameters.String("Bishop environment name", default='metrika.sandbox.admin.testing')

        _binary = binary_task.binary_release_parameters_list(stable=True)

    @property
    def resource_file(self):
        if self._resource_file is None:
            self._resource = self._resource_type(self, self._resource_file_name, self._resource_file_name)
            self._resource_file = self.resource_data.path

        return self._resource_file

    @property
    def resource_data(self):
        if self._resource_data is None:
            self._resource_data = sdk2.ResourceData(self._resource)

        return self._resource_data

    def on_execute(self):
        import metrika.pylib.log
        from metrika.pylib import config as mtconfig

        os.environ['ROBOT_METRIKA_ADMIN_OAUTH'] = sdk2.yav.Secret('sec-01cq6h07rwpqmqzb15y08jbs5q').data()['admin_oauth_token']
        metrika.pylib.log.init_logger('', stdout=True)
        self.config = mtconfig.get_yaml_config_from_bishop(
            program=self.Parameters.bishop_program,
            environment=self.Parameters.bishop_environment
        )

        self.prepare_keys_xml()
        self.bstr_push()

    def prepare_keys_xml(self):
        svn.Arcadia.export(SVN_PATH, self.resource_file)

    def bstr_push(self):
        bstr.bstr_push(file=self.resource_file, **self.config.bstr)
