# coding=utf-8
import logging

from sandbox import sdk2
from sandbox.common.types import resource as ctr
from sandbox.common.types.resource import State
from sandbox.common.types.task import ReleaseStatus
from sandbox.projects.common import binary_task
from sandbox.projects.metrika.utils.mixins.console import BaseConsoleMixin
from sandbox.projects.metrika.utils.resource_types import METRIKA_RELEASERS
from sandbox.projects.metrika.utils import CommonParameters
from sandbox.projects.metrika.utils.base_metrika_task import with_parents, BaseMetrikaTask
from sandbox.projects.metrika.utils.mixins.juggler_reporter import JugglerReporterMixin
from sandbox.projects.metrika.utils.mixins.dyn_resource import DynResourceMixin
from sandbox.projects import lbs
from sandbox.sdk2.path import Path


class METRIKA_LBS_BINBASE_GSM(sdk2.Resource):
    any_arch = True
    auto_backup = True
    restart_policy = ctr.RestartPolicy.DELETE
    releasable = True
    releasers = METRIKA_RELEASERS
    orig_resource = sdk2.Attributes.Integer('Оригинальный ресурс с архивом LBS', required=True)


class METRIKA_LBS_BINBASE_WIFI(sdk2.Resource):
    any_arch = True
    auto_backup = True
    restart_policy = ctr.RestartPolicy.DELETE
    releasable = True
    releasers = METRIKA_RELEASERS
    orig_resource = sdk2.Attributes.Integer('Оригинальный ресурс с архивом LBS', required=True)


@with_parents
class MetrikaUploadLbs(BaseMetrikaTask, JugglerReporterMixin, DynResourceMixin, BaseConsoleMixin):
    MUST_RELEASE = False

    RESOURCE_MAP = {
        lbs.LBS_BINBASE_GSM: METRIKA_LBS_BINBASE_GSM,
        lbs.LBS_BINBASE_WIFI: METRIKA_LBS_BINBASE_WIFI
    }

    class Parameters(CommonParameters):
        _binary = binary_task.binary_release_parameters_list(stable=True)

    def on_execute(self):
        for orig_resource_type, resource_type in self.RESOURCE_MAP.items():
            last_orig_resource = orig_resource_type.find(state=State.READY, released=ReleaseStatus.STABLE).first()
            last_resource = resource_type.find(state=State.READY, released=ReleaseStatus.STABLE).first()
            logging.debug('Last orig resource: %s', last_orig_resource)
            logging.debug('Last resource: %s', last_resource)
            if last_resource and last_resource.orig_resource == last_orig_resource.id:
                continue

            self.set_info('New {} found, unzipping'.format(last_orig_resource))
            last_orig_resource_path = sdk2.ResourceData(last_orig_resource).path
            resource_dir = Path(self.wd(resource_type.name.lower()))
            resource_dir.mkdir(parents=True)
            self._execute_script('gunzip -c {} > {}'.format(last_orig_resource_path, resource_dir.joinpath(last_orig_resource_path.stem)))
            resource_type(self, orig_resource_type.name, resource_dir, orig_resource=last_orig_resource.id)
