from sandbox import sdk2
from sandbox.common.types import resource as ctr
from sandbox.projects.common import binary_task
from sandbox.projects.metrika.utils.base_metrika_task import BaseMetrikaTask, with_parents
from sandbox.projects.metrika.utils.task_types.ya_make import MetrikaYaMake
from sandbox.projects.metrika.utils.mixins.dyn_resource import DynResourceMixin
from sandbox.projects.metrika.utils.mixins.juggler_reporter import JugglerReporterMixin
from sandbox.projects.metrika.utils.resource_types import METRIKA_RELEASERS


class MobileStartupEncryptedData(sdk2.Resource):
    any_arch = True
    auto_backup = True
    restart_policy = ctr.RestartPolicy.DELETE
    releasable = True
    releasers = METRIKA_RELEASERS


@with_parents
class MetrikaMobileStartupEncryptedDataBuild(BaseMetrikaTask, JugglerReporterMixin, DynResourceMixin):
    TARGET = 'metrika/core/programs/mobile-startup/data'
    FILES = [
        'bundle_ids/identity.bin',
        'sdk_list/sdk_list_android.bin',
        'sdk_list/sdk_list_android_safe.bin',
        'sdk_list/sdk_list_ios.bin',
    ]

    class Parameters(sdk2.Parameters):
        _binary = binary_task.binary_release_parameters_list(stable=True)

    @property
    def dyn_resources(self):
        return sdk2.Resource.find(task_id=self.Context.build_task, type=MobileStartupEncryptedData).limit(0)

    def on_execute(self):
        self.Context.build_task = self.run_subtasks([(
            MetrikaYaMake,
            dict(
                checkout_arcadia_from_url='arcadia-arc:/#trunk',
                targets=self.TARGET,
                arts=';'.join('{}/{}'.format(self.TARGET, file) for file in self.FILES),
                result_rd='encrypted_data',
                result_rt=MobileStartupEncryptedData.name
            )
        )])[0]
