from sandbox import sdk2
from sandbox.common.types import resource as ctr
from sandbox.projects import resource_types
from sandbox.projects.common import binary_task
from sandbox.projects.common.decorators import retries
from sandbox.projects.metrika.utils.mixins.console import BaseConsoleMixin
from sandbox.projects.metrika.utils.resource_types import METRIKA_RELEASERS
from sandbox.projects.metrika.utils import CommonParameters, settings
from sandbox.projects.metrika.utils.base_metrika_task import with_parents, BaseMetrikaTask
from sandbox.projects.metrika.utils.mixins.juggler_reporter import JugglerReporterMixin
from sandbox.projects.metrika.utils.mixins.dyn_resource import DynResourceMixin


class RegionsHierarchy(sdk2.Resource):
    any_arch = True
    auto_backup = True
    restart_policy = ctr.RestartPolicy.DELETE
    releasable = True
    releasers = METRIKA_RELEASERS


@with_parents
class MetrikaUploadRegionsHierarchy(BaseMetrikaTask, JugglerReporterMixin, DynResourceMixin, BaseConsoleMixin):
    class Parameters(CommonParameters):
        dict_checker_binary = sdk2.parameters.LastResource(
            'dictionary-checker', required=True, resource_type=resource_types.OTHER_RESOURCE, owner=settings.owner,
            attrs=dict(program='dictionary-checker')
        )
        _binary = binary_task.binary_release_parameters_list(stable=True)

    @retries(3)
    def on_execute(self):
        binary = sdk2.ResourceData(self.Parameters.dict_checker_binary)

        res = RegionsHierarchy(self, 'regions_hierarchy.txt', 'regions_hierarchy.txt')
        self._execute_script(
            "wget -O tmp_wget 'http://geoexport.yandex.ru/?fields=id,parent_id,type,population&types=_all_' && tail -n+2 tmp_wget > {}".format(
                res.path
            )
        )

        self._execute_shell_and_check([binary.path.as_posix(), 'region_hierarchy', res.path.as_posix()])
