import os
import shutil

from sandbox import sdk2
from sandbox.common.types import resource as ctr
from sandbox.projects.common import binary_task
from sandbox.projects.metrika.utils.mixins.dyn_resource import DynResourceMixin
from sandbox.projects.metrika.utils.resource_types import METRIKA_RELEASERS
from sandbox.projects.metrika.utils import CommonParameters, vcs
from sandbox.projects.metrika.utils.base_metrika_task import with_parents, BaseMetrikaTask
from sandbox.projects.metrika.utils.mixins.juggler_reporter import JugglerReporterMixin


class UATraits(sdk2.Resource):
    name = 'UA_TRAITS'
    any_arch = True
    auto_backup = True
    restart_policy = ctr.RestartPolicy.DELETE
    releasable = True
    releasers = METRIKA_RELEASERS


@with_parents
class MetrikaUploadUATraits(BaseMetrikaTask, JugglerReporterMixin, DynResourceMixin):
    name = 'METRIKA_UPLOAD_UA_TRAITS'

    class Parameters(CommonParameters):
        _binary = binary_task.binary_release_parameters_list(stable=True)

    def _juggler_predicate(self, status):
        return True

    def on_execute(self):
        res = UATraits(self, 'uatraits', self.path('wd', 'uatraits'))
        res.path.mkdir(parents=True)
        with vcs.mount_arc('arcadia-arc:/#trunk') as root:
            for file in ['browser.xml', 'profiles.xml', 'extra.xml']:
                shutil.copy(os.path.join(root, 'metrika/uatraits/data', file), res.path.joinpath(file).as_posix())
