from sandbox import sandboxsdk
from sandbox.projects.metrika.utils import settings, shell
from sandbox.sdk2 import ssh


def __get_remote_command(host, script):
    return ["ssh", "{}@{}".format(settings.login, host), "/bin/bash -xe <<'EOF'\n{}\nEOF".format(script)]


def execute_remote_script(task, host, script):
    with ssh.Key(task, settings.owner, settings.ssh_key):
        shell(task, __get_remote_command(host, script))


def get_remote_script_output(task, host, script):
    with ssh.Key(task, settings.owner, settings.ssh_key):
        return sandboxsdk.process.run_process(__get_remote_command(host, script), outs_to_pipe=True, wait=False).communicate()[0].strip()
