# coding=utf-8

from sandbox.projects.metrika.frontend.metrika_frontend_development import service_development_info
from sandbox.projects.metrika.utils.pipeline import contextable

common_metrika_images = [
    "metrika",
    "metrika-bem",
    "html2pdf",
    "about",
    "metrika-nginx",
]
common_metrika_s3_folders = {
    "services/metrika-bem/pages-desktop": "pages-desktop",
    "services/metrika-bem/metrika_3.0/build/static": "metrika_3.0/build/static",
    "services/metrika-bem/cdn": "cdn",
    "services/metrika-bem/metrika_3.0/build/js": "metrika_3.0/build/js",
    "services/metrika-bem/metrika_3.0/build/css": "metrika_3.0/build/css",
    "services/promo-metrika-2016/static/i": "i",
    "services/promo-metrika-2016/static/_upload/touch-phone.bundles": "touch-phone.bundles",
    "services/promo-metrika-2016/static/_upload/desktop.bundles": "desktop.bundles",
    "packages/form-selector/build/versioned": "form-selector",
    "packages/contrib/storybook-static": "storybook",
}
common_metrika_freeze_folders = {
    "services/metrika-bem/_": "_",
    "services/metrika/dist/static/_": "_",
    "services/promo-metrika-2016/static/_": "_",
    "packages/form-selector/build/nonversioned": "form-selector",
}


class DevelopmentInfo(contextable.Contextable):

    @property
    def service_development_info_dict(self):
        return dict((service_info.name, service_info) for service_info in
                    (service_development_info.ServiceDevelopmentInfo()
                     .with_name("metrika-frontend")
                     .with_repository("metrika/frontend")
                     .with_images(common_metrika_images[:])
                     .with_node_version_from("./Dockerfile.metrika")
                     .with_bucket("internal-metrika-betas")
                     .with_s3_folders(common_metrika_s3_folders.copy())
                     .with_s3_freeze_folders(common_metrika_freeze_folders.copy())
                     .with_url_template("https://{}.dev.metrika.yandex.ru/"),

                     service_development_info.ServiceDevelopmentInfo()
                     .with_name("metrika-assessor-frontend")
                     .with_repository("metrika/frontend")
                     .with_images(common_metrika_images[:])
                     .with_additional_build_variables({
                         "NODE_ENV": "production",
                         "CONFIG_ENV": "assessor"
                     })
                     .with_node_version_from("./Dockerfile.metrika")
                     .with_bucket("metrika-frontend-assessor-dev-betas")
                     .with_additional_static_build_variables({
                         "NODE_ENV": "production",
                         "YENV": "production",
                         "CONFIG_ENV": "assessor",
                     })
                     .with_s3_folders(common_metrika_s3_folders.copy())
                     .with_s3_freeze_folders(common_metrika_freeze_folders.copy())
                     .with_s3_static_compression(True)
                     .with_url_template("https://{}.crowdtest.metrika.yandex.ru/"),

                     service_development_info.ServiceDevelopmentInfo()
                     .with_name("radar-frontend")
                     .with_repository("metrika/frontend")
                     .with_images(["radar-bem", "radar-nginx"])
                     .with_node_version_from("./Dockerfile.radar-bem")
                     .with_bucket("internal-radar-betas")
                     .with_s3_folders({"services/radar-bem/pages-desktop": "pages-desktop"})
                     .with_s3_freeze_folders({"services/radar-bem/_": "_"})
                     .with_url_template("https://{}.dev.radar.yandex.ru/"),

                     service_development_info.ServiceDevelopmentInfo()
                     .with_name("audience-frontend")
                     .with_repository("metrika/frontend")
                     .with_images(["audience-bem", "audience-nginx"])
                     .with_node_version_from("./Dockerfile.audience-bem")
                     .with_bucket("internal-audience-betas")
                     .with_s3_folders({
                         "services/metrika-bem/pages-desktop": "pages-desktop",
                         "services/metrika-bem/metrika_3.0/build/static": "metrika_3.0/build/static",
                         "services/metrika-bem/cdn": "cdn",
                         "services/metrika-bem/metrika_3.0/build/js": "metrika_3.0/build/js",
                         "services/metrika-bem/metrika_3.0/build/css": "metrika_3.0/build/css",
                     })
                     .with_s3_freeze_folders({"services/metrika-bem/_": "_"})
                     .with_url_template("https://{}.dev.audience.yandex.ru/"),

                     service_development_info.ServiceDevelopmentInfo()
                     .with_name("appmetrica-frontend")
                     .with_repository("metrika/frontend")
                     .with_images([
                         "appmetrica",
                         "appmetrica-bem",
                         "appmetrica-nginx",
                     ])
                     .with_node_version_from("./Dockerfile.appmetrica")
                     .with_bucket("internal-appmetrica-betas")
                     .with_s3_folders({
                         "services/appmetrica-bem/blocks": "blocks",
                         "services/appmetrica-bem/desktop.pages": "desktop.pages",
                         "services/appmetrica-bem/react-components/build/js": "react-components/build/js",
                         "services/appmetrica-bem/react-components/build/css": "react-components/build/css"
                     })
                     .with_s3_freeze_folders({
                         "services/appmetrica-bem/_": "_",
                         "services/appmetrica-bem/react-components/build/_": "_",
                         "services/appmetrica/dist/static/_": "_"
                     })
                     .with_url_template("https://{}.dev.appmetrica.yandex.ru/"),

                     service_development_info.ServiceDevelopmentInfo()
                     .with_name("mediametrika-frontend")
                     .with_repository("metrika/frontend")
                     .with_images(["mediametrika"])
                     .with_node_version_from("./Dockerfile.mediametrika")
                     .with_bucket("internal-mediametrika-betas")
                     .with_s3_freeze_folders({"services/mediametrika/dist/static/_": "_"})
                     .with_url_template("https://{}.dev.media.metrika.yandex.ru/")
                     ))

    @property
    def author(self):
        return self._default_getter()

    @author.setter
    def author(self, value):
        self._default_setter(value)

    def with_author(self, value):
        return self._default_fluent_setter(value)

    @property
    def branch(self):
        return self._default_getter()

    @branch.setter
    def branch(self, value):
        self._default_setter(value)

    def with_branch(self, value):
        return self._default_fluent_setter(value)

    @property
    def stand_name(self):
        return self._default_getter()

    @stand_name.setter
    def stand_name(self, value):
        self._default_setter(value)

    def with_stand_name(self, value):
        return self._default_fluent_setter(value)

    @property
    def version(self):
        return self._default_getter()

    @version.setter
    def version(self, value):
        self._default_setter(value)

    def with_version(self, value):
        return self._default_fluent_setter(value)

    @property
    def service_state(self):
        return self._default_getter()

    @service_state.setter
    def service_state(self, value):
        self._default_setter(value)

    def with_service_state(self, value):
        return self._default_fluent_setter(value)

    @property
    def service(self):
        return service_development_info.ServiceDevelopmentInfo(self.service_state)

    @service.setter
    def service(self, value):
        self.service_state(value.state)

    def with_service(self, value):
        return self.with_service_state(value.state)

    def select_service(self, service):
        self.with_service(self.service_development_info_dict[service])
