# coding=utf-8

from sandbox.projects.metrika.admins import metrika_forsaken_stands_remove
from sandbox.projects.metrika.frontend import metrika_frontend_test_stand_create, metrika_frontend_test_stand_remove
from sandbox.projects.metrika.utils import base_metrika_task


@base_metrika_task.with_parents
class MetrikaFrontendForsakenStandsRemove(metrika_forsaken_stands_remove.MetrikaForsakenStandsRemove):
    """
    Удаление устаревших тестовых стендов для фронтенда Метрики
    """

    class Parameters(metrika_forsaken_stands_remove.MetrikaForsakenStandsRemove.Parameters):
        description = "Удаление устаревших тестовых стендов для фронтенда Метрики"

    def list_stands(self):
        stands = []
        for service in metrika_frontend_test_stand_create.SERVICES:
            project_id = service + "-autobetas"
            stands.extend(self.deploy_client.stage.list_project_stages(project_id))
        return [stand.get("id") for stand in stands]

    def delete_stand(self, stand):
        return (
            metrika_frontend_test_stand_remove.MetrikaFrontendTestStandRemove,
            dict(
                description="Forsaken " + stand,
                stage_name=stand
            )
        )
