# coding=utf-8
from __future__ import unicode_literals

from sandbox.projects.metrika.frontend.metrika_frontend_release import service_release_info
from sandbox.projects.metrika.utils import contextable


class ReleaseInfo(contextable.Contextable):
    def __init__(
        self,
        author=None, previous_release_version=None, release_version=None,
        changelog=None, short_log=None, linked_log=None,
        service=None
    ):
        self.author = author
        self.previous_release_version = previous_release_version
        self.release_version = release_version

        self.changelog = changelog
        self.short_log = short_log
        self.linked_log = linked_log

        self.service = service_release_info.ServiceReleaseInfo.fill(service)  # type: ServiceReleaseInfo

    def select_service(self, service):
        if not self.service:
            self.service = self.SERVICES[service]

    SERVICES = dict((service_release_info.name, service_release_info) for service_release_info in (
        service_release_info.ServiceReleaseInfo(
            name="appmetrica",
            repository="metrika/frontend",
            docker=service_release_info.DockerInfo(
                name="appmetrica",
                path="Dockerfile.appmetrica"
            ),
            extra_dockers=[
                service_release_info.DockerInfo(name="appmetrica-bem", path="Dockerfile.appmetrica-bem"),
                service_release_info.DockerInfo(name="appmetrica-nginx", path="Dockerfile.appmetrica-nginx")
            ],
            s3=service_release_info.S3Info(
                bucket_name="appmetrica",
                folders={
                    "services/appmetrica-bem/blocks": "blocks",
                    "services/appmetrica-bem/desktop.pages": "desktop.pages",
                    "services/appmetrica-bem/react-components/build/js": "react-components/build/js",
                    "services/appmetrica-bem/react-components/build/css": "react-components/build/css"
                },
                freeze_folders={
                    "services/appmetrica-bem/_": "_",
                    "services/appmetrica-bem/react-components/build/_": "_",
                    "services/appmetrica/dist/static/_": "_"
                }
            ),
            release_issue=service_release_info.IssueInfo(
                queue="MOBMET",
                component=1726,
                followers=["gakuznetsov", "elakov", "kholodny-d", "dancingelf"]
            ),
            node_version="12"
        ),

        service_release_info.ServiceReleaseInfo(
            name="audience",
            repository="metrika/frontend",
            docker=service_release_info.DockerInfo(
                name="audience-bem",
                path="Dockerfile.audience-bem"
            ),
            extra_dockers=[
                service_release_info.DockerInfo(name="audience-nginx", path="Dockerfile.audience-nginx")
            ],
            s3=service_release_info.S3Info(
                folders={
                    "services/metrika-bem/blocks": "blocks",
                    "services/metrika-bem/cdn": "cdn",
                    "services/metrika-bem/pages-desktop": "pages-desktop",
                    "services/metrika-bem/metrika_3.0/build/js": "metrika_3.0/build/js",
                    "services/metrika-bem/metrika_3.0/build/css": "metrika_3.0/build/css",
                    "services/metrika-bem/metrika_3.0/build/static": "metrika_3.0/build/static"
                },
                freeze_folders={"services/metrika-bem/_": "_"}
            ),
            release_issue=service_release_info.IssueInfo(
                queue="AUDIENCE",
                component=33718,
                followers=["gakuznetsov", "nkatherine", "eugenenik", "sergeydenisov"]
            ),
        ),

        service_release_info.ServiceReleaseInfo(
            name="metrika",
            repository="metrika/frontend",
            docker=service_release_info.DockerInfo(
                name="metrika",
                path="Dockerfile.metrika",
            ),
            extra_dockers=[
                service_release_info.DockerInfo(name="metrika-nginx", path="Dockerfile.metrika-nginx"),
                service_release_info.DockerInfo(name="metrika-bem", path="Dockerfile.metrika-bem"),
                service_release_info.DockerInfo(name="html2pdf", path="Dockerfile.html2pdf"),
                service_release_info.DockerInfo(name="about", path="Dockerfile.about"),
            ],
            s3=service_release_info.S3Info(
                folders={
                    "services/metrika-bem/blocks": "blocks",
                    "services/metrika-bem/cdn": "cdn",
                    "services/metrika-bem/pages-desktop": "pages-desktop",
                    "services/metrika-bem/metrika_3.0/build/js": "metrika_3.0/build/js",
                    "services/metrika-bem/metrika_3.0/build/css": "metrika_3.0/build/css",
                    "services/metrika-bem/metrika_3.0/build/static": "metrika_3.0/build/static",
                    "services/promo-metrika-2016/static/i": "i",
                    "services/promo-metrika-2016/static/_upload/touch-phone.bundles": "touch-phone.bundles",
                    "services/promo-metrika-2016/static/_upload/desktop.bundles": "desktop.bundles",
                    "packages/form-selector/build/versioned": "form-selector",
                },
                freeze_folders={
                    "services/metrika/dist/static/_": "_",
                    "services/metrika-bem/_": "_",
                    "services/promo-metrika-2016/static/_": "_",
                    "packages/form-selector/build/nonversioned": "form-selector",
                }
            ),
            release_issue=service_release_info.IssueInfo(
                queue="METR",
                component=1452,
                followers=["gakuznetsov", "nkatherine", "eugenenik", "sergeydenisov"],
            ),
        ),

        service_release_info.ServiceReleaseInfo(
            name="radar",
            repository="metrika/frontend",
            docker=service_release_info.DockerInfo(
                name="radar-bem",
                path="Dockerfile.radar-bem"
            ),
            extra_dockers=[
                service_release_info.DockerInfo(name="radar-nginx", path="Dockerfile.radar-nginx")
            ],
            s3=service_release_info.S3Info(
                folders={"services/radar-bem/pages-desktop": "pages-desktop"},
                freeze_folders={
                    "services/radar-bem/_": "_",
                }
            ),
            release_issue=service_release_info.IssueInfo(
                queue="RADAR",
                component=36610,
                followers=["gakuznetsov", "nkatherine", "eugenenik", "sergeydenisov", "gbiz"]
            )
        ),

        service_release_info.ServiceReleaseInfo(
            name="mediametrika",
            repository="metrika/frontend",
            docker=service_release_info.DockerInfo(
                name="mediametrika",
                path="Dockerfile.mediametrika"
            ),
            s3=service_release_info.S3Info(
                folders={"services/mediametrika/dist/static/bundles": "bundles"},
                freeze_folders={"services/mediametrika/dist/static/_": "_"}
            ),
            release_issue=service_release_info.IssueInfo(
                queue="METRADV",
                component=45131,
                followers=["gakuznetsov", "nkatherine", "eugenenik", "sergeydenisov", "sourx", "elakov"]
            )
        )
    ))
