# coding=utf-8
from __future__ import unicode_literals

from sandbox.projects.metrika.utils import contextable


class S3Info(contextable.Contextable):
    """
    :param Dict[unicode, unicode] folders:
    :param Dict[unicode, unicode] freeze_folders:
    :param unicode bucket_name:
    """

    def __init__(self, folders=None, freeze_folders=None, bucket_name=None):
        self.folders = folders or {}
        self.freeze_folders = freeze_folders or {}
        self.bucket_name = bucket_name


class DockerInfo(contextable.Contextable):
    """
    :param unicode name:
    :param unicode path:
    :param Dict[unicode, unicode] env:
    """

    def __init__(self, name, path=None, env=None):
        self.name = name
        self.path = path or "./Dockerfile"
        self.env = env or {}


class IssueInfo(contextable.Contextable):
    """
    :param unicode queue:
    :param int component:
    :param List[unicode] followers:
    :param unicode key:
    :param int board:
    """

    def __init__(self, queue, component, followers=None, key=None, board=None):
        self.queue = queue
        self.component = component
        self.followers = followers or []
        self.key = key
        self.board = board


class ServiceReleaseInfo(contextable.Contextable):
    """
    :param unicode name:
    :param unicode repository:
    :param IssueInfo release_issue:
    :param S3Info s3:
    :param DockerInfo docker:
    :param List[DockerInfo] extra_dockers:
    :param unicode node_version:
    :param List[str] changelog_extra_tags:
    """

    def __init__(
        self, name, repository,
        release_issue,
        s3=None,
        docker=None,
        extra_dockers=None,
        node_version=None,
        changelog_extra_tags=None
    ):
        self.name = name
        self.repository = repository
        self.release_issue = IssueInfo.fill(release_issue)

        self.s3 = S3Info.fill(s3)
        if self.s3 and not self.s3.bucket_name:
            self.s3.bucket_name = self.name

        self.docker = DockerInfo.fill(docker)
        self.extra_dockers = extra_dockers and [DockerInfo.fill(ed) for ed in extra_dockers]
        self.node_version = node_version
        self.changelog_extra_tags = changelog_extra_tags or []
