# coding=utf-8
import os

import sandbox.projects.common.build.parameters as build_parameters
from sandbox import sdk2
from sandbox.common.types import resource as ctr
from sandbox.projects.common import binary_task
from sandbox.projects.metrika.utils.mixins.console import BaseConsoleMixin
from sandbox.projects.metrika.utils.resource_types import METRIKA_RELEASERS
from sandbox.projects.metrika.utils.task_types.ya_make import MetrikaYaMake


class MetrikaJavaDoc(sdk2.Resource):
    any_arch = True
    auto_backup = True
    restart_policy = ctr.RestartPolicy.DELETE
    releasers = METRIKA_RELEASERS


class MetrikaJavaBuildDoc(MetrikaYaMake, BaseConsoleMixin):
    class Parameters(MetrikaYaMake.Parameters):
        description = 'Сборка Java документации из metrika/java/api/documentation'

        checkout_arcadia_from_url = build_parameters.ArcadiaUrl(default_value='arcadia-arc:/#trunk')
        targets = sdk2.parameters.String('Targets (semicolon separated)', default_value='metrika/java/api/documentation', required=True)

        _binary = binary_task.binary_release_parameters_list(stable=True)

    def post_build(self, source_dir, output_dir, pack_dir):
        jdk_resource = sdk2.ResourceData(sdk2.Resource[2460637517])
        jdk_dir = self.path('jdk')
        jdk_dir.mkdir()
        self._execute_shell_and_check(['tar', '-zxf', jdk_resource.path.as_posix(), '-C', jdk_dir.as_posix()])

        doc_dir = self.path('documentation')
        doc_dir.mkdir()
        self._execute_script('cp -r {src}/* {dst}'.format(src=os.path.join(output_dir, self.Parameters.targets), dst=doc_dir))
        self._execute_script('cp -r {src}/* {dst}'.format(src=os.path.join(source_dir, self.Parameters.targets), dst=doc_dir))
        self._execute_script(
            'cd {doc} && {java} -Dfile.encoding=UTF-8 -cp "yandex-metrika-documentation/*" --add-opens java.base/java.lang=ALL-UNNAMED "ru.yandex.metrika.documentation.DocTreeGenerator2"'.format(
                doc=doc_dir, java=jdk_dir.joinpath('bin', 'java')
            ),
        )
        MetrikaJavaDoc(self, 'java documentation', doc_dir.joinpath('doc'))
