# coding=utf-8
import json

from sandbox.projects.metrika.java.utils import deploy_test_stand
from sandbox.projects.metrika.utils.pipeline import contextable


class DaemonDevelopmentInfo(contextable.Contextable):

    @property
    def name(self):
        return self._default_getter()

    @name.setter
    def name(self, value):
        self._default_setter(value)

    def with_name(self, value):
        return self._default_fluent_setter(value)

    @property
    def version(self):
        return self._default_getter()

    @version.setter
    def version(self, value):
        self._default_setter(value)

    def with_version(self, value):
        return self._default_fluent_setter(value)

    @property
    def under_auto_tests(self):
        return self._default_getter()

    @under_auto_tests.setter
    def under_auto_tests(self, value):
        self._default_setter(value)

    def with_under_auto_tests(self, value):
        return self._default_fluent_setter(value)

    @property
    def restartable(self):
        return self._default_getter()

    @restartable.setter
    def restartable(self, value):
        self._default_setter(value)

    def with_restartable(self, value):
        return self._default_fluent_setter(value)

    @property
    def deploy_test_stand_state(self):
        return self._default_getter()

    @deploy_test_stand_state.setter
    def deploy_test_stand_state(self, value):
        self._default_setter(value)

    def with_deploy_test_stand_state(self, value):
        return self._default_fluent_setter(value)

    @property
    def deploy_test_stand(self):
        return deploy_test_stand.DeployTestStand(self.deploy_test_stand_state)

    @deploy_test_stand.setter
    def deploy_test_stand(self, value):
        self.deploy_test_stand_state(value.state)

    def with_deploy_test_stand(self, value):
        return self.with_deploy_test_stand_state(value.state)

    @property
    def deploy_ref_stand_state(self):
        return self._default_getter()

    @deploy_ref_stand_state.setter
    def deploy_ref_stand_state(self, value):
        self._default_setter(value)

    def with_deploy_ref_stand_state(self, value):
        return self._default_fluent_setter(value)

    @property
    def deploy_ref_stand(self):
        return deploy_test_stand.DeployTestStand(self.deploy_ref_stand_state)

    @deploy_ref_stand.setter
    def deploy_ref_stand(self, value):
        self.deploy_ref_stand_state(value.state)

    def with_deploy_ref_stand(self, value):
        return self.with_deploy_ref_stand_state(value.state)

    @property
    def tests_build_configuration_template(self):
        return self._default_getter()

    @tests_build_configuration_template.setter
    def tests_build_configuration_template(self, value):
        self._default_setter(value)

    def with_tests_build_configuration_template(self, value):
        return self._default_fluent_setter(value)

    @property
    def tests_build_configuration(self):
        return json.loads(self.tests_build_configuration_template.format(self.name, self.deploy_test_stand.fqdn))

    @property
    def tests_run_configuration_template(self):
        return self._default_getter()

    @tests_run_configuration_template.setter
    def tests_run_configuration_template(self, value):
        self._default_setter(value)

    def with_tests_run_configuration_template(self, value):
        return self._default_fluent_setter(value)

    @property
    def tests_run_configuration(self):
        return json.loads(self.tests_run_configuration_template.format(self.deploy_test_stand.fqdn, self.deploy_ref_stand.fqdn))

    @property
    def tests_task_id(self):
        return self._default_getter()

    @tests_task_id.setter
    def tests_task_id(self, value):
        self._default_setter(value)

    def with_tests_task_id(self, value):
        return self._default_fluent_setter(value)

    @property
    def need_semaphore(self):
        return self._default_getter()

    @need_semaphore.setter
    def need_semaphore(self, value):
        self._default_setter(value)

    def with_need_semaphore(self, value):
        return self._default_fluent_setter(value)
