# coding=utf-8

from sandbox.projects.metrika.java.metrika_java_development import daemon_development_info
from sandbox.projects.metrika.java.utils import deploy_test_stand, metrika_java_helper
from sandbox.projects.metrika.utils.pipeline import contextable

ADVAPI_TESTS_BUILD_CONFIGURATION_TEMPLATE = """
{{
  "{0}/pom.xml": {{
    "schemas.server": "http://{1}:8080"
  }}
}}
"""

ADVAPI_TESTS_RUN_CONFIGURATION_TEMPLATE = """
{{
  "advapi-ft": {{
    "api.uri": "http://{0}:8080"
  }},
  "advapi-b2b": {{
    "api.testing": "http://{0}:8080",
    "api.reference": "http://{1}:8080"
  }}
}}
"""

AUDIENCE_INTAPI_TESTS_BUILD_CONFIGURATION_TEMPLATE = """
{{
  "{0}/pom.xml": {{
    "schemas.server": "http://{1}:8080"
  }}
}}
"""

AUDIENCE_INTAPI_TESTS_RUN_CONFIGURATION_TEMPLATE = """
{{
  "audience-intapi": {{
    "api.uri": "http://{0}:8080"
  }}
}}
"""

AUDIENCEAPID_TESTS_BUILD_CONFIGURATION_TEMPLATE = """
{{
  "{0}/pom.xml": {{
    "schemas.server": "http://{1}:8080"
  }}
}}
"""

AUDIENCEAPID_TESTS_RUN_CONFIGURATION_TEMPLATE = """
{{
  "audience-api": {{
    "api.uri": "http://{0}:8080"
  }}
}}
"""

FACED_TESTS_BUILD_CONFIGURATION_TEMPLATE = """
{{
  "{0}/pom.xml": {{
    "schemas.server": "http://{1}:8080"
  }}
}}
"""

FACED_TESTS_RUN_CONFIGURATION_TEMPLATE = """
{{
  "json-schemas": {{
    "api.testing": "http://{0}:8080",
    "api.reference": "http://{1}:8080"
  }},
  "metrika-2-api-ft": {{
    "api.testing": "http://{0}:8080"
  }},
  "metrika-2-api-ft-durable": {{
    "api.testing": "http://{0}:8080"
  }},
  "metrika-2-api-b2b": {{
    "api.testing": "http://{0}:8080",
    "api.reference": "http://{1}:8080"
  }},
  "metrika-2-api-management": {{
    "api.testing": "http://{0}:8080"
  }},
  "metrika-2-api-segments": {{
    "api.testing": "http://{0}:8080",
    "api.segments.type": "API"
  }},
  "metrika-2-api-webmaster": {{
    "api.testing": "http://{0}:8080"
  }}
}}
"""

WEBVISOR_API_TESTS_BUILD_CONFIGURATION_TEMPLATE = """
{{
  "{0}/pom.xml": {{
    "schemas.server": "http://{1}:8080"
  }}
}}
"""

WEBVISOR_API_TESTS_RUN_CONFIGURATION_TEMPLATE = """
{{
  "json-schemas": {{
    "api.testing": "http://{0}:8080",
    "api.reference": "http://{1}:8080"
  }},
  "webvisor-api-b2b": {{
    "api.testing": "http://{0}:8080",
    "api.reference": "http://{1}:8080"
  }},
  "webvisor-api-ft": {{
    "api.testing": "http://{0}:8080"
  }}
}}
"""

MOBMETD_TESTS_BUILD_CONFIGURATION_TEMPLATE = """
{{
  "{0}/pom.xml": {{
    "schemas.server": "http://{1}:8080"
  }}
}}
"""

MOBMETD_TESTS_RUN_CONFIGURATION_TEMPLATE = """
{{
  "appmetrica-management-api": {{
    "api.testing": "http://{0}:8080",
    "api.reference": "http://{1}:8080"
  }},
  "appmetrica-reporting-api": {{
    "api.testing": "http://{0}:8080",
    "api.reference": "http://{1}:8080"
  }}
}}
"""

PUSH_API_TESTS_BUILD_CONFIGURATION_TEMPLATE = """
{{
  "{0}/pom.xml": {{
    "schemas.server": "http://{1}:8080"
  }}
}}
"""

PUSH_API_TESTS_RUN_CONFIGURATION_TEMPLATE = """
{{
  "appmetrica-push-api": {{
    "api.testing": "http://{0}:8080"
  }}
}}
"""

TOPSITES_TESTS_BUILD_CONFIGURATION_TEMPLATE = """
{{
  "{0}/pom.xml": {{
    "schemas.server": "http://{1}:8080"
  }}
}}
"""

TOPSITES_TESTS_RUN_CONFIGURATION_TEMPLATE = """
{{
  "topsites": {{
    "api.uri": "http://{0}:8080"
  }}
}}
"""

INTERNALAPID_TESTS_BUILD_CONFIGURATION_TEMPLATE = """
{{
  "{0}/pom.xml": {{
    "schemas.server": "http://{1}:8080"
  }}
}}
"""

INTERNALAPID_TESTS_RUN_CONFIGURATION_TEMPLATE = """
{{
  "internalapid": {{
    "api.uri": "http://{0}:8080"
  }}
}}
"""

TESTS_RUN_CONFIGURATION_TEMPLATE = """
{{
  "pack": {{
    "api.testing": "http://{0}:8080",
    "api.reference": "http://{1}:8080"
  }}
}}
"""


class DevelopmentInfo(contextable.Contextable):

    @property
    def daemon_development_info_dict(self):
        return dict((info.name, info) for info in
                    (daemon_development_info.DaemonDevelopmentInfo()
                     .with_name("advapi")
                     .with_under_auto_tests(True)
                     .with_restartable(True)
                     .with_deploy_test_stand(deploy_test_stand.DeployTestStand()
                                             .with_maas_parent("Parent-80"))
                     .with_deploy_ref_stand(deploy_test_stand.DeployTestStand()
                                            .with_maas_parent("Parent-80"))
                     .with_tests_build_configuration_template(ADVAPI_TESTS_BUILD_CONFIGURATION_TEMPLATE)
                     .with_tests_run_configuration_template(ADVAPI_TESTS_RUN_CONFIGURATION_TEMPLATE),

                     daemon_development_info.DaemonDevelopmentInfo()
                     .with_name("audience-intapi")
                     .with_under_auto_tests(True)
                     .with_restartable(True)
                     .with_deploy_test_stand(deploy_test_stand.DeployTestStand()
                                             .with_maas_parent("Parent-80"))
                     .with_tests_build_configuration_template(AUDIENCE_INTAPI_TESTS_BUILD_CONFIGURATION_TEMPLATE)
                     .with_tests_run_configuration_template(AUDIENCE_INTAPI_TESTS_RUN_CONFIGURATION_TEMPLATE),

                     daemon_development_info.DaemonDevelopmentInfo()
                     .with_name("audienceapid")
                     .with_under_auto_tests(True)
                     .with_restartable(True)
                     .with_deploy_test_stand(deploy_test_stand.DeployTestStand()
                                             .with_maas_parent("Parent-80"))
                     .with_tests_build_configuration_template(AUDIENCEAPID_TESTS_BUILD_CONFIGURATION_TEMPLATE)
                     .with_tests_run_configuration_template(AUDIENCEAPID_TESTS_RUN_CONFIGURATION_TEMPLATE),

                     daemon_development_info.DaemonDevelopmentInfo()
                     .with_name("faced")
                     .with_under_auto_tests(True)
                     .with_restartable(True)
                     .with_deploy_test_stand(deploy_test_stand.DeployTestStand()
                                             .with_maas_parent("distilled-80"))
                     .with_deploy_ref_stand(deploy_test_stand.DeployTestStand()
                                            .with_maas_parent("distilled-80"))
                     .with_tests_build_configuration_template(FACED_TESTS_BUILD_CONFIGURATION_TEMPLATE)
                     .with_tests_run_configuration_template(FACED_TESTS_RUN_CONFIGURATION_TEMPLATE)
                     .with_need_semaphore(True),

                     daemon_development_info.DaemonDevelopmentInfo()
                     .with_name("webvisor-api")
                     .with_under_auto_tests(True)
                     .with_restartable(True)
                     .with_deploy_test_stand(deploy_test_stand.DeployTestStand()
                                             .with_maas_parent("distilled-80"))
                     .with_deploy_ref_stand(deploy_test_stand.DeployTestStand()
                                            .with_maas_parent("distilled-80"))
                     .with_tests_build_configuration_template(WEBVISOR_API_TESTS_BUILD_CONFIGURATION_TEMPLATE)
                     .with_tests_run_configuration_template(WEBVISOR_API_TESTS_RUN_CONFIGURATION_TEMPLATE)
                     .with_need_semaphore(True),

                     daemon_development_info.DaemonDevelopmentInfo()
                     .with_name("mobmetd")
                     .with_under_auto_tests(True)
                     .with_restartable(True)
                     .with_deploy_test_stand(deploy_test_stand.DeployTestStand()
                                             .with_maas_parent("Parent-80"))
                     .with_deploy_ref_stand(deploy_test_stand.DeployTestStand()
                                            .with_maas_parent("Parent-80"))
                     .with_tests_build_configuration_template(MOBMETD_TESTS_BUILD_CONFIGURATION_TEMPLATE)
                     .with_tests_run_configuration_template(MOBMETD_TESTS_RUN_CONFIGURATION_TEMPLATE),

                     daemon_development_info.DaemonDevelopmentInfo()
                     .with_name("push-api")
                     .with_under_auto_tests(True)
                     .with_restartable(True)
                     .with_deploy_test_stand(deploy_test_stand.DeployTestStand()
                                             .with_maas_parent("Parent-80"))
                     .with_tests_build_configuration_template(PUSH_API_TESTS_BUILD_CONFIGURATION_TEMPLATE)
                     .with_tests_run_configuration_template(PUSH_API_TESTS_RUN_CONFIGURATION_TEMPLATE),

                     daemon_development_info.DaemonDevelopmentInfo()
                     .with_name("topsites")
                     .with_under_auto_tests(True)
                     .with_restartable(True)
                     .with_deploy_test_stand(deploy_test_stand.DeployTestStand()
                                             .with_maas_parent("Parent-80"))
                     .with_tests_build_configuration_template(TOPSITES_TESTS_BUILD_CONFIGURATION_TEMPLATE)
                     .with_tests_run_configuration_template(TOPSITES_TESTS_RUN_CONFIGURATION_TEMPLATE),

                     daemon_development_info.DaemonDevelopmentInfo()
                     .with_name("internalapid")
                     .with_under_auto_tests(True)
                     .with_restartable(True)
                     .with_deploy_test_stand(deploy_test_stand.DeployTestStand()
                                             .with_maas_parent("Parent-80"))
                     .with_tests_build_configuration_template(INTERNALAPID_TESTS_BUILD_CONFIGURATION_TEMPLATE)
                     .with_tests_run_configuration_template(INTERNALAPID_TESTS_RUN_CONFIGURATION_TEMPLATE),

                     daemon_development_info.DaemonDevelopmentInfo()
                     .with_name("cdp-api")
                     .with_deploy_test_stand(deploy_test_stand.DeployTestStand()
                                             .with_daemon_name("cdp-api")
                                             .with_bishop_environment_prefix("cdp")
                                             .with_maas_parent("Parent-80")),

                     daemon_development_info.DaemonDevelopmentInfo()
                     .with_name("cdp-intapi")
                     .with_deploy_test_stand(deploy_test_stand.DeployTestStand()
                                             .with_daemon_name("cdp-intapi")
                                             .with_bishop_environment_prefix("cdp")
                                             .with_maas_parent("Parent-80")))
                    )

    @property
    def author(self):
        return self._default_getter()

    @author.setter
    def author(self, value):
        self._default_setter(value)

    def with_author(self, value):
        return self._default_fluent_setter(value)

    @property
    def arcadia_url(self):
        return self._default_getter()

    @arcadia_url.setter
    def arcadia_url(self, value):
        self._default_setter(value)

    def with_arcadia_url(self, value):
        return self._default_fluent_setter(value)

    @property
    def ref_version(self):
        return self._default_getter()

    @ref_version.setter
    def ref_version(self, value):
        self._default_setter(value)

    def with_ref_version(self, value):
        return self._default_fluent_setter(value)

    @property
    def daemons_info_state(self):
        return self._default_getter()

    @daemons_info_state.setter
    def daemons_info_state(self, value):
        self._default_setter(value)

    def with_daemons_info_state(self, value):
        return self._default_fluent_setter(value)

    def fill_daemons_info_state(self, daemon_dictionary):
        self.with_daemons_info_state(
            [self.daemon_development_info_dict.get(daemon, daemon_development_info.DaemonDevelopmentInfo().with_name(daemon))
                 .with_version(version).state for daemon, version in daemon_dictionary.items()]
        )

    @property
    def daemons_info(self):
        return [daemon_development_info.DaemonDevelopmentInfo(info) for info in self.daemons_info_state]

    @property
    def daemons_deploy_stands(self):
        return self.daemons_deploy_test_stands + self.daemons_deploy_ref_stands

    @property
    def daemons_deploy_test_stands(self):
        return [info.deploy_test_stand for info in self.daemons_info if info.deploy_test_stand_state is not None]

    @property
    def daemons_deploy_ref_stands(self):
        return [info.deploy_ref_stand for info in self.daemons_info if info.deploy_ref_stand_state is not None]

    def fill_deploy_stands_names(self, stand_name_template, tracker_issue, ref_version, vanilla):
        for info in (info for info in self.daemons_info if info.deploy_test_stand_state is not None):
            test_stand_name = stand_name_template.format(author=self.author, tracker_issue=tracker_issue.lower() if tracker_issue else '')
            test_stand_name = test_stand_name.rstrip('-')

            info.deploy_test_stand.name = test_stand_name
            info.deploy_test_stand.daemon_name = info.name
            info.deploy_test_stand.version = info.version

            if vanilla:
                info.deploy_test_stand.maas_parent = "vanilla-80"

            if info.deploy_ref_stand_state is not None:
                info.deploy_ref_stand.name = test_stand_name + "-ref"
                info.deploy_ref_stand.daemon_name = info.name
                info.deploy_ref_stand.version = ref_version or metrika_java_helper.MetrikaJavaHelper.get_version(info.name, "testing")

                if vanilla:
                    info.deploy_ref_stand.maas_parent = "vanilla-80"

    def has_b2b_stands(self):
        return self.daemons_deploy_ref_stands
