# coding=utf-8

from sandbox.projects.metrika.admins import metrika_forsaken_stands_remove
from sandbox.projects.metrika.java import metrika_java_test_stand_remove
from sandbox.projects.metrika.utils import base_metrika_task


@base_metrika_task.with_parents
class MetrikaJavaForsakenStandsRemove(metrika_forsaken_stands_remove.MetrikaForsakenStandsRemove):
    """
    Удаление устаревших тестовых стендов для java-демонов Метрики
    """

    class Parameters(metrika_forsaken_stands_remove.MetrikaForsakenStandsRemove.Parameters):
        description = "Удаление устаревших тестовых стендов для java-демонов Метрики"

    def list_stands(self):
        return [stand.get("id") for stand in self.deploy_client.stage.list_project_stages("metrika-java-autobetas")]

    def delete_stand(self, stand):
        return (
            metrika_java_test_stand_remove.MetrikaJavaTestStandRemove,
            dict(
                description="Forsaken " + stand,
                stage_name=stand
            )
        )
