# coding=utf-8
import json

from sandbox.projects.common.decorators import memoized_property
from sandbox.projects.metrika.java import utils
from sandbox.projects.metrika.java.utils import deploy_test_stand
from sandbox.projects.metrika.utils.pipeline import contextable


class DaemonReleaseInfo(contextable.Contextable):

    @staticmethod
    def new():
        return DaemonReleaseInfo().with_release_issue_queue("METR").with_release_issue_component(1449)

    @property
    def name(self):
        return self._default_getter()

    @name.setter
    def name(self, value):
        self._default_setter(value)

    def with_name(self, value):
        return self._default_fluent_setter(value)

    @property
    def version(self):
        return self._default_getter()

    @version.setter
    def version(self, value):
        self._default_setter(value)

    def with_version(self, value):
        return self._default_fluent_setter(value)

    @property
    def previous_version(self):
        return self._default_getter()

    @previous_version.setter
    def previous_version(self, value):
        self._default_setter(value)

    def with_previous_version(self, value):
        return self._default_fluent_setter(value)

    @property
    def changelog(self):
        return self._default_getter()

    @changelog.setter
    def changelog(self, value):
        self._default_setter(value)

    def with_changelog(self, value):
        return self._default_fluent_setter(value)

    @property
    def short_log(self):
        return self._default_getter()

    @short_log.setter
    def short_log(self, value):
        self._default_setter(value)

    def with_short_log(self, value):
        return self._default_fluent_setter(value)

    @property
    def linked_log(self):
        return self._default_getter()

    @linked_log.setter
    def linked_log(self, value):
        self._default_setter(value)

    def with_linked_log(self, value):
        return self._default_fluent_setter(value)

    @property
    def release_issue_key(self):
        return self._default_getter()

    @release_issue_key.setter
    def release_issue_key(self, value):
        self._default_setter(value)

    def with_release_issue_key(self, value):
        return self._default_fluent_setter(value)

    @property
    def release_issue_queue(self):
        return self._default_getter()

    @release_issue_queue.setter
    def release_issue_queue(self, value):
        self._default_setter(value)

    def with_release_issue_queue(self, value):
        return self._default_fluent_setter(value)

    @property
    def release_issue_component(self):
        return self._default_getter()

    @release_issue_component.setter
    def release_issue_component(self, value):
        self._default_setter(value)

    def with_release_issue_component(self, value):
        return self._default_fluent_setter(value)

    @property
    def release_issue_followers(self):
        return self._default_getter()

    @release_issue_followers.setter
    def release_issue_followers(self, value):
        self._default_setter(value)

    def with_release_issue_followers(self, value):
        return self._default_fluent_setter(value)

    @property
    def tests_issue_key(self):
        return self._default_getter()

    @tests_issue_key.setter
    def tests_issue_key(self, value):
        self._default_setter(value)

    def with_tests_issue_key(self, value):
        return self._default_fluent_setter(value)

    @property
    def under_tests(self):
        return self._default_getter()

    @under_tests.setter
    def under_tests(self, value):
        self._default_setter(value)

    def with_under_tests(self, value):
        return self._default_fluent_setter(value)

    @property
    def under_auto_tests(self):
        return self._default_getter()

    @under_auto_tests.setter
    def under_auto_tests(self, value):
        self._default_setter(value)

    def with_under_auto_tests(self, value):
        return self._default_fluent_setter(value)

    @property
    def restartable(self):
        return self._default_getter()

    @restartable.setter
    def restartable(self, value):
        self._default_setter(value)

    def with_restartable(self, value):
        return self._default_fluent_setter(value)

    @property
    def deploy_test_stand_state(self):
        return self._default_getter()

    @deploy_test_stand_state.setter
    def deploy_test_stand_state(self, value):
        self._default_setter(value)

    def with_deploy_test_stand_state(self, value):
        return self._default_fluent_setter(value)

    @property
    def deploy_test_stand(self):
        return deploy_test_stand.DeployTestStand(self.deploy_test_stand_state)

    @deploy_test_stand.setter
    def deploy_test_stand(self, value):
        self.deploy_test_stand_state(value.state)

    def with_deploy_test_stand(self, value):
        return self.with_deploy_test_stand_state(value.state)

    @property
    def deploy_ref_stand_state(self):
        return self._default_getter()

    @deploy_ref_stand_state.setter
    def deploy_ref_stand_state(self, value):
        self._default_setter(value)

    def with_deploy_ref_stand_state(self, value):
        return self._default_fluent_setter(value)

    @property
    def deploy_ref_stand(self):
        return deploy_test_stand.DeployTestStand(self.deploy_ref_stand_state)

    @deploy_ref_stand.setter
    def deploy_ref_stand(self, value):
        self.deploy_ref_stand_state(value.state)

    def with_deploy_ref_stand(self, value):
        return self.with_deploy_ref_stand_state(value.state)

    @property
    def tests_build_configuration_template(self):
        return self._default_getter()

    @tests_build_configuration_template.setter
    def tests_build_configuration_template(self, value):
        self._default_setter(value)

    def with_tests_build_configuration_template(self, value):
        return self._default_fluent_setter(value)

    @property
    def tests_build_configuration(self):
        return json.loads(self._default_getter() or self.tests_build_configuration_template.format(self.name, self.deploy_test_stand.fqdn))

    @tests_build_configuration.setter
    def tests_build_configuration(self, value):
        self._default_setter(value)

    def with_tests_build_configuration(self, value):
        return self._default_fluent_setter(value)

    @property
    def tests_run_configuration_template(self):
        return self._default_getter()

    @tests_run_configuration_template.setter
    def tests_run_configuration_template(self, value):
        self._default_setter(value)

    def with_tests_run_configuration_template(self, value):
        return self._default_fluent_setter(value)

    @property
    def integration_tests_build_configuration_template(self):
        return self._default_getter()

    @integration_tests_build_configuration_template.setter
    def integration_tests_build_configuration_template(self, value):
        self._default_setter(value)

    def with_integration_tests_build_configuration_template(self, value):
        return self._default_fluent_setter(value)

    @property
    def integration_tests_build_configuration(self):
        return self.integration_tests_build_configuration_template.format(self.name, self.integration_tests_host)

    @property
    def integration_tests_run_configuration_template(self):
        return self._default_getter()

    @integration_tests_run_configuration_template.setter
    def integration_tests_run_configuration_template(self, value):
        self._default_setter(value)

    def with_integration_tests_run_configuration_template(self, value):
        return self._default_fluent_setter(value)

    @property
    def integration_tests_run_configuration(self):
        return self.integration_tests_run_configuration_template.format(self.integration_tests_host)

    @property
    def tests_run_configuration(self):
        return json.loads(self._default_getter() or self.tests_run_configuration_template.format(self.deploy_test_stand.fqdn, self.deploy_ref_stand.fqdn))

    @tests_run_configuration.setter
    def tests_run_configuration(self, value):
        self._default_setter(value)

    def with_tests_run_configuration(self, value):
        return self._default_fluent_setter(value)

    @property
    def tests_task_id(self):
        return self._default_getter()

    @tests_task_id.setter
    def tests_task_id(self, value):
        self._default_setter(value)

    def with_tests_task_id(self, value):
        return self._default_fluent_setter(value)

    @property
    def need_semaphore(self):
        return self._default_getter()

    @need_semaphore.setter
    def need_semaphore(self, value):
        self._default_setter(value)

    def with_need_semaphore(self, value):
        return self._default_fluent_setter(value)

    @property
    def integration_tests_group(self):
        return self._default_getter()

    @integration_tests_group.setter
    def integration_tests_group(self, value):
        self._default_setter(value)

    def with_integration_tests_group(self, value):
        return self._default_fluent_setter(value)

    @memoized_property
    def integration_tests_host(self):
        if not self.integration_tests_group:
            return None

        return utils.get_host(self.integration_tests_group)
