# coding=utf-8

from sandbox.projects.metrika.java.metrika_java_release import daemon_release_info
from sandbox.projects.metrika.java.utils import deploy_test_stand, metrika_java_helper
from sandbox.projects.metrika.utils.pipeline import contextable

ADVAPI_TESTS_BUILD_CONFIGURATION_TEMPLATE = """
{{
  "{0}/pom.xml": {{
    "schemas.server": "http://{1}:8080"
  }}
}}
"""

ADVAPI_TESTS_RUN_CONFIGURATION_TEMPLATE = """
{{
  "advapi-ft": {{
    "api.uri": "http://{0}:8080"
  }},
  "advapi-b2b": {{
    "api.testing": "http://{0}:8080",
    "api.reference": "http://{1}:8080"
  }}
}}
"""

AUDIENCE_INTAPI_TESTS_BUILD_CONFIGURATION_TEMPLATE = """
{{
  "{0}/pom.xml": {{
    "schemas.server": "http://{1}:8080"
  }}
}}
"""

AUDIENCE_INTAPI_TESTS_RUN_CONFIGURATION_TEMPLATE = """
{{
  "audience-intapi": {{
    "api.uri": "http://{0}:8080"
  }}
}}
"""

AUDIENCEAPID_TESTS_BUILD_CONFIGURATION_TEMPLATE = """
{{
  "{0}/pom.xml": {{
    "schemas.server": "http://{1}:8080"
  }}
}}
"""

AUDIENCEAPID_TESTS_RUN_CONFIGURATION_TEMPLATE = """
{{
  "audience-api": {{
    "api.uri": "http://{0}:8080"
  }}
}}
"""

FACED_TESTS_BUILD_CONFIGURATION_TEMPLATE = """
{{
  "{0}/pom.xml": {{
    "schemas.server": "http://{1}:8080"
  }}
}}
"""

FACED_TESTS_RUN_CONFIGURATION_TEMPLATE = """
{{
  "molly": {{
  }},
  "metrika-2-api-ft": {{
    "api.testing": "http://{0}:8080"
  }},
  "metrika-2-api-ft-durable": {{
    "api.testing": "http://{0}:8080"
  }},
  "metrika-2-api-management": {{
    "api.testing": "http://{0}:8080"
  }},
  "json-schemas": {{
    "api.testing": "http://{0}:8080",
    "api.reference": "http://{1}:8080"
  }},
  "metrika-2-api-b2b": {{
    "api.testing": "http://{0}:8080",
    "api.reference": "http://{1}:8080"
  }},
  "metrika-2-api-segments": {{
    "api.testing": "http://{0}:8080",
    "api.segments.type": "API"
  }}
}}
"""

FACED_INTEGRATION_TESTS_BUILD_CONFIGURATION_TEMPLATE = """
{{
  "{0}/pom.xml": {{
    "schemas.server": "http://{1}:8080"
  }}
}}
"""

FACED_INTEGRATION_TESTS_RUN_CONFIGURATION_TEMPLATE = """
{{
    "metrika-2-api-integration": {{
        "api.testing": "http://{0}:8080"
    }}
}}
"""

WEBVISOR_API_TESTS_BUILD_CONFIGURATION_TEMPLATE = """
{{
  "{0}/pom.xml": {{
    "schemas.server": "http://{1}:8080"
  }}
}}
"""

WEBVISOR_API_TESTS_RUN_CONFIGURATION_TEMPLATE = """
{{
  "webvisor-api-ft": {{
    "api.testing": "http://{0}:8080"
  }},
  "json-schemas": {{
    "api.testing": "http://{0}:8080",
    "api.reference": "http://{1}:8080"
  }},
  "webvisor-api-b2b": {{
    "api.testing": "http://{0}:8080",
    "api.reference": "http://{1}:8080"
  }}
}}
"""

MOBMETD_TESTS_BUILD_CONFIGURATION_TEMPLATE = """
{{
  "{0}/pom.xml": {{
    "schemas.server": "http://{1}:8080"
  }}
}}
"""

MOBMETD_TESTS_RUN_CONFIGURATION_TEMPLATE = """
{{
  "appmetrica-management-api": {{
    "api.testing": "http://{0}:8080",
    "api.reference": "http://{1}:8080"
  }},
  "appmetrica-reporting-api": {{
    "api.testing": "http://{0}:8080",
    "api.reference": "http://{1}:8080"
  }}
}}
"""

PUSH_API_TESTS_BUILD_CONFIGURATION_TEMPLATE = """
{{
  "{0}/pom.xml": {{
    "schemas.server": "http://{1}:8080"
  }}
}}
"""

PUSH_API_TESTS_RUN_CONFIGURATION_TEMPLATE = """
{{
  "appmetrica-push-api": {{
    "api.testing": "http://{0}:8080"
  }}
}}
"""

TOPSITES_TESTS_BUILD_CONFIGURATION_TEMPLATE = """
{{
  "{0}/pom.xml": {{
    "schemas.server": "http://{1}:8080"
  }}
}}
"""

TOPSITES_TESTS_RUN_CONFIGURATION_TEMPLATE = """
{{
  "topsites": {{
    "api.uri": "http://{0}:8080"
  }}
}}
"""

INTERNALAPID_TESTS_BUILD_CONFIGURATION_TEMPLATE = """
{{
  "{0}/pom.xml": {{
    "schemas.server": "http://{1}:8080"
  }}
}}
"""

INTERNALAPID_TESTS_RUN_CONFIGURATION_TEMPLATE = """
{{
  "internalapid": {{
    "api.uri": "http://{0}:8080"
  }}
}}
"""


class ReleaseInfo(contextable.Contextable):

    @property
    def daemon_release_info_dict(self):
        return dict((info.name, info) for info in
                    (daemon_release_info.DaemonReleaseInfo.new()
                     .with_name("advapi")
                     .with_release_issue_queue("METRADV")
                     .with_release_issue_component(45129)
                     .with_under_tests(True)
                     .with_under_auto_tests(True)
                     .with_restartable(True)
                     .with_deploy_test_stand(deploy_test_stand.DeployTestStand()
                                             .with_maas_parent("Parent-80"))
                     .with_deploy_ref_stand(deploy_test_stand.DeployTestStand()
                                            .with_maas_parent("Parent-80"))
                     .with_tests_build_configuration_template(ADVAPI_TESTS_BUILD_CONFIGURATION_TEMPLATE)
                     .with_tests_run_configuration_template(ADVAPI_TESTS_RUN_CONFIGURATION_TEMPLATE)
                     .with_need_semaphore(True),

                     daemon_release_info.DaemonReleaseInfo.new()
                     .with_name("adv-intapi")
                     .with_release_issue_queue("METRADV")
                     .with_release_issue_component(45129)
                     .with_under_tests(True),

                     daemon_release_info.DaemonReleaseInfo.new()
                     .with_name("adv-lambda")
                     .with_release_issue_queue("METRADV")
                     .with_release_issue_component(45130),

                     daemon_release_info.DaemonReleaseInfo.new()
                     .with_name("audience-intapi")
                     .with_release_issue_queue("AUDIENCE")
                     .with_release_issue_component(33720)
                     .with_release_issue_followers(["nkatherine", "eugenenik", "sergeydenisov"])
                     .with_under_tests(True)
                     .with_under_auto_tests(True)
                     .with_restartable(True)
                     .with_deploy_test_stand(deploy_test_stand.DeployTestStand()
                                             .with_maas_parent("Parent-80"))
                     .with_tests_build_configuration_template(AUDIENCE_INTAPI_TESTS_BUILD_CONFIGURATION_TEMPLATE)
                     .with_tests_run_configuration_template(AUDIENCE_INTAPI_TESTS_RUN_CONFIGURATION_TEMPLATE),

                     daemon_release_info.DaemonReleaseInfo.new()
                     .with_name("audienceapid")
                     .with_release_issue_queue("AUDIENCE")
                     .with_release_issue_component(33720)
                     .with_release_issue_followers(["nkatherine", "eugenenik", "sergeydenisov"])
                     .with_under_tests(True)
                     .with_under_auto_tests(True)
                     .with_restartable(True)
                     .with_deploy_test_stand(deploy_test_stand.DeployTestStand()
                                             .with_maas_parent("Parent-80"))
                     .with_tests_build_configuration_template(AUDIENCEAPID_TESTS_BUILD_CONFIGURATION_TEMPLATE)
                     .with_tests_run_configuration_template(AUDIENCEAPID_TESTS_RUN_CONFIGURATION_TEMPLATE),

                     daemon_release_info.DaemonReleaseInfo.new()
                     .with_name("audience-crypta-sender")
                     .with_release_issue_queue("AUDIENCE")
                     .with_release_issue_component(33720)
                     .with_release_issue_followers(["nkatherine", "eugenenik", "sergeydenisov"])
                     .with_under_tests(True),

                     daemon_release_info.DaemonReleaseInfo.new()
                     .with_name("audience-bs-sender")
                     .with_release_issue_queue("AUDIENCE")
                     .with_release_issue_component(33720)
                     .with_release_issue_followers(["nkatherine", "eugenenik", "sergeydenisov"]),

                     daemon_release_info.DaemonReleaseInfo.new()
                     .with_name("audience-geo-import")
                     .with_release_issue_queue("AUDIENCE")
                     .with_release_issue_component(33720)
                     .with_release_issue_followers(["nkatherine", "eugenenik", "sergeydenisov"]),

                     daemon_release_info.DaemonReleaseInfo.new()
                     .with_name("faced")
                     .with_release_issue_component(9483)
                     .with_release_issue_followers(["nkatherine", "eugenenik", "sergeydenisov",
                                                    "p-yakovlev", "orantius", "sourx", "eryabokon"])
                     .with_under_tests(True)
                     .with_under_auto_tests(True)
                     .with_restartable(True)
                     .with_deploy_test_stand(deploy_test_stand.DeployTestStand()
                                             .with_maas_parent("distilled-80"))
                     .with_deploy_ref_stand(deploy_test_stand.DeployTestStand()
                                            .with_maas_parent("distilled-80"))
                     .with_tests_build_configuration_template(FACED_TESTS_BUILD_CONFIGURATION_TEMPLATE)
                     .with_tests_run_configuration_template(FACED_TESTS_RUN_CONFIGURATION_TEMPLATE)
                     .with_need_semaphore(True)
                     .with_integration_tests_build_configuration_template(FACED_INTEGRATION_TESTS_BUILD_CONFIGURATION_TEMPLATE)
                     .with_integration_tests_run_configuration_template(FACED_INTEGRATION_TESTS_RUN_CONFIGURATION_TEMPLATE)
                     .with_integration_tests_group("faced-testing"),

                     daemon_release_info.DaemonReleaseInfo.new()
                     .with_name("webvisor-api")
                     .with_release_issue_component(9483)
                     .with_release_issue_followers(["nkatherine", "eugenenik", "sergeydenisov", "orantius", "sourx"])
                     .with_under_tests(True)
                     .with_under_auto_tests(True)
                     .with_restartable(True)
                     .with_deploy_test_stand(deploy_test_stand.DeployTestStand()
                                             .with_maas_parent("distilled-80"))
                     .with_deploy_ref_stand(deploy_test_stand.DeployTestStand()
                                            .with_maas_parent("distilled-80"))
                     .with_tests_build_configuration_template(WEBVISOR_API_TESTS_BUILD_CONFIGURATION_TEMPLATE)
                     .with_tests_run_configuration_template(WEBVISOR_API_TESTS_RUN_CONFIGURATION_TEMPLATE)
                     .with_need_semaphore(True),

                     daemon_release_info.DaemonReleaseInfo.new()
                     .with_name("internalapid")
                     .with_release_issue_component(9483)
                     .with_release_issue_followers(["nkatherine", "eugenenik", "sergeydenisov"])
                     .with_under_tests(True)
                     .with_under_auto_tests(True)
                     .with_restartable(True)
                     .with_deploy_test_stand(deploy_test_stand.DeployTestStand()
                                             .with_maas_parent("Parent-80"))
                     .with_tests_build_configuration_template(INTERNALAPID_TESTS_BUILD_CONFIGURATION_TEMPLATE)
                     .with_tests_run_configuration_template(INTERNALAPID_TESTS_RUN_CONFIGURATION_TEMPLATE),

                     daemon_release_info.DaemonReleaseInfo.new()
                     .with_name("report-order-processor")
                     .with_release_issue_followers(["nkatherine", "eugenenik", "sergeydenisov"])
                     .with_under_tests(True),

                     daemon_release_info.DaemonReleaseInfo.new()
                     .with_name("mobmetd")
                     .with_release_issue_queue("MOBMET")
                     .with_release_issue_component(1727)
                     .with_release_issue_followers(["dancingelf"])
                     .with_under_tests(True)
                     .with_under_auto_tests(True)
                     .with_restartable(True)
                     .with_deploy_test_stand(deploy_test_stand.DeployTestStand()
                                             .with_maas_parent("Parent-80"))
                     .with_deploy_ref_stand(deploy_test_stand.DeployTestStand()
                                            .with_maas_parent("Parent-80"))
                     .with_tests_build_configuration_template(MOBMETD_TESTS_BUILD_CONFIGURATION_TEMPLATE)
                     .with_tests_run_configuration_template(MOBMETD_TESTS_RUN_CONFIGURATION_TEMPLATE),

                     daemon_release_info.DaemonReleaseInfo.new()
                     .with_name("mobmet-crash-decoder")
                     .with_release_issue_queue("MOBMET")
                     .with_release_issue_component(1727),

                     daemon_release_info.DaemonReleaseInfo.new()
                     .with_name("mobmet-scheduler")
                     .with_release_issue_queue("MOBMET")
                     .with_release_issue_component(1727),

                     daemon_release_info.DaemonReleaseInfo.new()
                     .with_name("mobmet-intapi")
                     .with_release_issue_queue("MOBMET")
                     .with_release_issue_component(1727)
                     .with_under_tests(True),

                     daemon_release_info.DaemonReleaseInfo.new()
                     .with_name("push-api")
                     .with_release_issue_queue("MOBMET")
                     .with_release_issue_component(1727)
                     .with_under_tests(True)
                     .with_restartable(True)
                     .with_deploy_test_stand(deploy_test_stand.DeployTestStand()
                                             .with_maas_parent("Parent-80"))
                     .with_tests_build_configuration_template(PUSH_API_TESTS_BUILD_CONFIGURATION_TEMPLATE)
                     .with_tests_run_configuration_template(PUSH_API_TESTS_RUN_CONFIGURATION_TEMPLATE),

                     daemon_release_info.DaemonReleaseInfo.new()
                     .with_name("push-dispatcher")
                     .with_release_issue_queue("MOBMET")
                     .with_release_issue_component(1727)
                     .with_under_tests(True),

                     daemon_release_info.DaemonReleaseInfo.new()
                     .with_name("push-sender")
                     .with_release_issue_queue("MOBMET")
                     .with_release_issue_component(1727)
                     .with_under_tests(True),

                     daemon_release_info.DaemonReleaseInfo.new()
                     .with_name("push-writer")
                     .with_release_issue_queue("MOBMET")
                     .with_release_issue_component(1727)
                     .with_under_tests(True),

                     daemon_release_info.DaemonReleaseInfo.new()
                     .with_name("topsites")
                     .with_release_issue_queue("RADAR")
                     .with_release_issue_component(36611)
                     .with_under_tests(True)
                     .with_under_auto_tests(True)
                     .with_restartable(True)
                     .with_deploy_test_stand(deploy_test_stand.DeployTestStand()
                                             .with_maas_parent("Parent-80"))
                     .with_tests_build_configuration_template(TOPSITES_TESTS_BUILD_CONFIGURATION_TEMPLATE)
                     .with_tests_run_configuration_template(TOPSITES_TESTS_RUN_CONFIGURATION_TEMPLATE),

                     daemon_release_info.DaemonReleaseInfo.new()
                     .with_name("topsites-scheduler")
                     .with_release_issue_queue("RADAR")
                     .with_release_issue_component(36612)
                     .with_under_tests(True),

                     daemon_release_info.DaemonReleaseInfo.new()
                     .with_name("visor3d")
                     .with_release_issue_followers(["nkatherine", "eugenenik", "sergeydenisov"])
                     .with_under_tests(True),

                     daemon_release_info.DaemonReleaseInfo.new()
                     .with_name("proxy2d")
                     .with_release_issue_followers(["nkatherine", "eugenenik", "sergeydenisov"])
                     .with_under_tests(True),

                     daemon_release_info.DaemonReleaseInfo.new()
                     .with_name("visord")
                     .with_release_issue_followers(["nkatherine", "eugenenik", "sergeydenisov"])
                     .with_under_tests(True),

                     daemon_release_info.DaemonReleaseInfo.new()
                     .with_name("proxyd")
                     .with_release_issue_followers(["nkatherine", "eugenenik", "sergeydenisov"])
                     .with_under_tests(True),

                     daemon_release_info.DaemonReleaseInfo.new()
                     .with_name("lambda-visits")
                     .with_release_issue_followers(["nkatherine", "eugenenik", "sergeydenisov"]),

                     daemon_release_info.DaemonReleaseInfo.new()
                     .with_name("expenses-processor")
                     .with_release_issue_followers(["nkatherine", "eugenenik", "sergeydenisov"]))
                    )

    @property
    def author(self):
        return self._default_getter()

    @author.setter
    def author(self, value):
        self._default_setter(value)

    def with_author(self, value):
        return self._default_fluent_setter(value)

    @property
    def previous_release_version(self):
        return self._default_getter()

    @previous_release_version.setter
    def previous_release_version(self, value):
        self._default_setter(value)

    def with_previous_release_version(self, value):
        return self._default_fluent_setter(value)

    @property
    def release_version(self):
        return self._default_getter()

    @release_version.setter
    def release_version(self, value):
        self._default_setter(value)

    def with_release_version(self, value):
        return self._default_fluent_setter(value)

    @property
    def daemons_info_state(self):
        return self._default_getter()

    @daemons_info_state.setter
    def daemons_info_state(self, value):
        self._default_setter(value)

    def with_daemons_info_state(self, value):
        return self._default_fluent_setter(value)

    def fill_daemons_info_state(self, daemon_list):
        self.with_daemons_info_state(
            [self.daemon_release_info_dict.get(daemon, daemon_release_info.DaemonReleaseInfo.new().with_name(daemon))
                 .with_version(self.release_version).state for daemon in daemon_list]
        )

    @property
    def daemons_info(self):
        return [daemon_release_info.DaemonReleaseInfo(info) for info in self.daemons_info_state]

    @property
    def daemons_deploy_stands(self):
        return self.daemons_deploy_test_stands + self.daemons_deploy_ref_stands

    @property
    def daemons_deploy_test_stands(self):
        return [info.deploy_test_stand for info in self.daemons_info if info.deploy_test_stand_state is not None]

    @property
    def daemons_deploy_ref_stands(self):
        return [info.deploy_ref_stand for info in self.daemons_info if info.deploy_ref_stand_state is not None]

    def fill_deploy_stands_names(self):
        for info in (info for info in self.daemons_info if info.deploy_test_stand_state is not None):
            info.deploy_test_stand.name = "release"
            info.deploy_test_stand.daemon_name = info.name
            info.deploy_test_stand.version = self.release_version

            if info.deploy_ref_stand_state is not None:
                info.deploy_ref_stand.name = "release-ref"
                info.deploy_ref_stand.daemon_name = info.name
                info.deploy_ref_stand.version = metrika_java_helper.MetrikaJavaHelper.get_stable_version(info.name)
