# coding=utf-8
import re

from sandbox.projects.common import binary_task
from sandbox.projects.metrika.utils import CommonParameters
from sandbox.projects.metrika.utils import parameters
from sandbox.projects.metrika.utils import settings
from sandbox.projects.metrika.utils.base_metrika_task import with_parents, BaseMetrikaTask
from sandbox.projects.metrika.utils.mixins import juggler_reporter
from sandbox.projects.metrika.utils.mixins.console import BaseConsoleMixin
from sandbox.sdk2 import ssh
from sandbox.sdk2.vcs.svn import Arcadia, SvnError


@with_parents
class MetrikaJavaTankerDownload(BaseMetrikaTask, BaseConsoleMixin, juggler_reporter.JugglerReporterMixin):
    """
    Загрузка переводов из танкера
    """

    class Parameters(CommonParameters):
        description = "Загрузка переводов из танкера"

        container = parameters.LastPeasantContainerResource("Environment container resource", required=True)

        _binary = binary_task.binary_release_parameters_list(stable=True)

    def on_execute(self):
        path = self.path('wd')
        path.mkdir()
        Arcadia.checkout('arcadia:/arc/trunk/arcadia/metrika/java/api', path.as_posix())

        self._execute_shell_and_check(['builder/src/sh/import-tanker.sh'], cwd=path.as_posix())
        locales_path = path.joinpath('common', 'locale', 'po').as_posix()
        Arcadia.svn('add', opts='--force', path=locales_path)

        with ssh.Key(self, settings.owner, settings.ssh_key):
            try:
                Arcadia.commit(locales_path, 'Update from tanker, SB task: {}'.format(self.id), user=settings.login)
            except SvnError as e:
                if e.error_code != 'E165001':  # blocked by pre-commit hook
                    raise
                else:
                    self.set_info('<a href="{}">Ревью</a>'.format(re.search(r'https://a\.yandex-team\.ru.*', str(e)).group()), do_escape=False)
