# coding=utf-8
import os

from sandbox import sdk2
from sandbox.projects.common import binary_task
from sandbox.projects.metrika.utils import CommonParameters, parameters, settings, vcs
from sandbox.projects.metrika.utils.base_metrika_task import with_parents, BaseMetrikaTask
from sandbox.projects.metrika.utils.mixins import juggler_reporter
from sandbox.projects.metrika.utils.mixins.console import BaseConsoleMixin


@with_parents
class MetrikaJavaTankerUpload(BaseMetrikaTask, BaseConsoleMixin, juggler_reporter.JugglerReporterMixin):
    """
    Регулярная выгрузка в танкер
    """

    class Requirements(BaseMetrikaTask.Requirements):
        privileged = True
        disk_space = 2 * 1024

    class Parameters(CommonParameters):
        description = "Регулярная выгрузка в танкер"

        container = parameters.LastPeasantContainerResource("Environment container resource", required=True)

        arcadia_url = sdk2.parameters.ArcadiaUrl("URL Аркадии", required=True, default_value="arcadia-arc:/#trunk",
                                                 description="Опционально ветка или коммит, из которого делать выгрузку строк в танкер")

        send = sdk2.parameters.Bool("Отправлять ли строки в Танкер или только подготовить", default=True)

        force_upload = sdk2.parameters.Bool("Игнорировать лимит в 100 фраз", default=False)

        with sdk2.parameters.Group("Секреты") as secrets:
            tokens_secret = sdk2.parameters.YavSecret("Секрет с токенами", required=True, default=settings.yav_uuid)

            yav_token_key = sdk2.parameters.String("Ключ токена Секретницы в секрете", required=True, default="yav-token")

        _binary = binary_task.binary_release_parameters_list(stable=True)

    def on_execute(self):
        with vcs.mount_arc(self.Parameters.arcadia_url) as arcadia:
            self.build(arcadia)

    def build(self, path):
        env = os.environ.copy()
        env["PATH"] = env["PATH"] + ":" + path
        env["YAV_TOKEN"] = self.Parameters.tokens_secret.data().get(self.Parameters.yav_token_key)

        args = ["metrika/java/api/builder/src/sh/export-tanker.sh"]
        if self.Parameters.send:
            args += ["--send"]
        if self.Parameters.force_upload:
            args += ["--force"]

        self._execute_shell_and_check(args, cwd=path, env=env)
