from sandbox import sdk2
from sandbox.common.types import resource as ctr
from sandbox.projects.common import binary_task
from sandbox.projects.common.decorators import retries
from sandbox.projects.metrika.utils import CommonParameters
from sandbox.projects.metrika.utils.base_metrika_task import with_parents, BaseMetrikaTask
from sandbox.projects.metrika.utils.mixins.console import BaseConsoleMixin
from sandbox.projects.metrika.utils.mixins.dyn_resource import DynResourceMixin
from sandbox.projects.metrika.utils.mixins.juggler_reporter import JugglerReporterMixin
from sandbox.projects.metrika.utils.resource_types import METRIKA_RELEASERS


class MetrikaJavaGeo(sdk2.Resource):
    any_arch = True
    auto_backup = True
    restart_policy = ctr.RestartPolicy.DELETE
    releasable = True
    releasers = METRIKA_RELEASERS


@with_parents
class MetrikaUploadJavaGeo(BaseMetrikaTask, JugglerReporterMixin, DynResourceMixin, BaseConsoleMixin):
    RESOURCE_COUNT = 3

    class Parameters(CommonParameters):
        _binary = binary_task.binary_release_parameters_list(stable=True)

    @retries(3)
    def on_execute(self):
        res = MetrikaJavaGeo(self, 'java_geo', 'java_geo.tsv')
        self._execute_script(
            'curl -s "http://geoexport.yandex.ru/?fields=Id,Parent,Type,Runame,Trname,Enname,Ukname,Lat,Lon,Iso&types=1,2,3,4,5,6,7,8,9,10,11,12,13,14,15" | '
            'sed "s/\r//" | sort -k 1 -n > {}'.format(res.path)
        )
