# coding=utf8
from __future__ import unicode_literals

from sandbox import sdk2
from sandbox.projects.metrika.utils import settings


def get_host(stage):
    """
    :param stage: Стейдж в деплое
    :return str: Один из хостов
    """

    from metrika.pylib.deploy import client

    api = client.DeployAPI(token=sdk2.yav.Secret(settings.yav_uuid).data()['deploy-token'])
    deploy_unit = list(api.stage.get_stage(stage, selectors=['/spec/deploy_units']).keys())[0]
    for address in [client.VLA_ADDRESS, client.IVA_ADDRESS, client.SAS_ADDRESS, client.MAN_ADDRESS, client.MYT_ADDRESS]:
        api = client.DeployAPI(token=sdk2.yav.Secret(settings.yav_uuid).data()['deploy-token'], address=address)
        fqdn = api.yp_client.select_objects(
            b'pod', filter="[/meta/pod_set_id]='{}.{}'".format(stage, deploy_unit),
            selectors=['/status/ip6_address_allocations/0/persistent_fqdn']
        )
        if fqdn:
            return fqdn[0][0]
    raise Exception('No hosts founds in deploy for deploy unit {}'.format(stage))
