from sandbox import sdk2
from sandbox.sdk2.environments import TarballToolkitBase


class IosSimulator(sdk2.Resource):
    """
        Tarball with iOS Simulator
    """
    version = sdk2.Attributes.String('version', required=True)
    platform = sdk2.Attributes.String('platform', required=True)
    any_arch = False
    auto_backup = True
    ttl = 'inf'


class IosSimulatorEnvironment(TarballToolkitBase):
    """
        iOS Simulator environment
    """
    resource_type = IosSimulator
    name = 'ios_simulator'

    STABLE = '14.4'

    def __init__(self, version=None):
        super(IosSimulatorEnvironment, self).__init__(version or IosSimulatorEnvironment.STABLE, 'darwin')

    def get_environment_folder(self):
        return IosSimulatorEnvironment.simulator_path(self.version)

    @staticmethod
    def simulator_path(version):
        return "/Library/Developer/CoreSimulator/Profiles/Runtimes/iOS {}.simruntime".format(version)
