#!/bin/bash

set -e

YA_BIN="$(arc root)/ya"
VERSION="$(date +"%Y.%m.%d-%H.%M")"

"$YA_BIN" make --target-platform=DEFAULT-DARWIN-X86_64
"$YA_BIN" upload ./upload_system_ios_symbols \
    -T SANDBOX_TASKS_BINARY \
    --arch=osx \
    --attr tasks_bundle=UPLOAD_SYSTEM_IOS_SYMBOLS \
    --attr target=upload_system_ios_symbols \
    --attr version="$VERSION" \
    --attr release=test

echo "version:"
echo "$VERSION"
