set -o errexit
set -o xtrace

dpkg --add-architecture i386
apt-get -yqq update || true
apt-get install -qq --assume-yes --no-install-recommends daemon cpu-checker curl git git-lfs ca-certificates zip unzip yandex-openjdk11 qemu-kvm libvirt-bin ubuntu-vm-builder bridge-utils libxdamage1 libxfixes3 libc6:i386 libncurses5:i386 libstdc++6:i386 zlib1g:i386 xvfb

##########################################
# install android sdk tools
# to download the latest version use link from https://developer.android.com/studio
##########################################

curl --verbose --insecure -o sdk-cmdline-tools.zip https://dl.google.com/android/repository/commandlinetools-linux-7583922_latest.zip
unzip sdk-cmdline-tools.zip -d downloads
mkdir -p /usr/local/android-sdk/cmdline-tools
sudo mv /downloads/cmdline-tools /usr/local/android-sdk/cmdline-tools/latest
rm sdk-cmdline-tools.zip

##########################################
# set PATH and other env variables to make all work
##########################################

tee /etc/profile.d/66-android.sh << "EOF"
export ANDROID_HOME=/usr/local/android-sdk
export ANDROID_SDK_HOME=/usr/local/android-sdk
export PATH=$ANDROID_HOME/platform-tools:$ANDROID_HOME/emulator:$ANDROID_HOME/tools:$ANDROID_HOME/cmdline-tools/latest/bin:$PATH
export SHELL=/bin/bash
export LD_LIBRARY_PATH=$ANDROID_HOME/emulator/lib64/:$ANDROID_HOME/emulator/lib64/gles_mesa:$ANDROID_HOME/emulator/lib64/gles_swiftshader:$ANDROID_HOME/emulator/lib64/qt/lib/:$LD_LIBRARY_PATH
ldconfig
EOF

tee /etc/profile.d/55-java.sh << "EOF"
export JAVA_HOME=/usr/local/java
EOF

. /etc/profile

##########################################
# installing android tools
##########################################

yes | sdkmanager --licenses

yes | sdkmanager "tools"
yes | sdkmanager "platform-tools"
yes | sdkmanager "build-tools;28.0.3"
yes | sdkmanager "build-tools;29.0.3"
yes | sdkmanager "build-tools;30.0.3"
yes | sdkmanager "ndk-bundle"
yes | sdkmanager "emulator" --channel=3
yes | sdkmanager "platforms;android-{api_level}"
yes | sdkmanager "system-images;android-{api_level};{api};{platform}"

echo "n" | avdmanager create avd -n "api-{api_level}-{platform}-google" -k "system-images;android-{api_level};{api};{platform}" {avdmanager_create_args}

chmod -R 0777 /usr/local/android-sdk

##########################################
# add android licenses
##########################################

mkdir -p /usr/local/android-sdk/licenses
echo "" >/usr/local/android-sdk/licenses/android-sdk-license
echo "d56f5187479451eabf01fb78af6dfcb131a6481e" >>/usr/local/android-sdk/licenses/android-sdk-license
echo -n "24333f8a63b6825ea9c5514f83c2829b004d1fee" >>/usr/local/android-sdk/licenses/android-sdk-license

##########################################
# emulator
##########################################

tee /usr/local/bin/emulator-prepare.sh << "EOF"
#!/bin/bash
. /etc/profile

density=$1
width=$2
height=$3

ls /usr/local/android-sdk/.android/avd/*/config.ini | while read f; do
    sed -i.bak '/hw.lcd.density=/ d; /hw.lcd.width=/ d; /hw.lcd.height=/ d' "$f"
    echo hw.lcd.density=$density >> "$f"
    echo hw.lcd.width=$width >> "$f"
    echo hw.lcd.height=$height >> "$f"
done

EOF
chmod 755 /usr/local/bin/emulator-prepare.sh

##########################################
# logcat
##########################################

tee /usr/local/bin/logcat-start.sh << "EOF"
#!/bin/bash
. /etc/profile

LOGS_DIR=${{1:-/var/log}}
echo "Logs dir: $LOGS_DIR"

daemon --verbose --name logcat-G --unsafe --errlog=$LOGS_DIR/logcat-G.error.log --dbglog=$LOGS_DIR/logcat-G.debug.log --output=$LOGS_DIR/logcat-G.output.log  -- adb logcat -G 16M
daemon --verbose --name logcat --unsafe --errlog=$LOGS_DIR/logcat.error.log --dbglog=$LOGS_DIR/logcat.debug.log --output=$LOGS_DIR/logcat.output.log --respawn  -- adb logcat -v time
EOF
chmod 755 /usr/local/bin/logcat-start.sh

tee /usr/local/bin/logcat-stop.sh << "EOF"
#!/bin/bash

daemon --stop --verbose --name logcat
EOF
chmod 755 /usr/local/bin/logcat-stop.sh

tee /usr/local/bin/logcat-status.sh << "EOF"
#!/bin/bash

daemon --running --verbose --name logcat
EOF
chmod 755 /usr/local/bin/logcat-stop.sh

##########################################
# Xvfb to use gui without gui
##########################################

tee /usr/local/bin/Xvfb-start.sh << "EOF"
#!/bin/bash
. /etc/profile

LOGS_DIR=${{1:-/var/log}}
echo "Logs dir: $LOGS_DIR"

# create display to be able to run with -gpu mesa to make webview work
# set TMPDIR - workaround for bug:
# https://bugs.launchpad.net/ubuntu/+source/xorg-server/+bug/972324

TMPDIR=/var/tmp daemon --verbose --name Xvfb --unsafe --errlog=$LOGS_DIR/Xvfb.error.log --dbglog=$LOGS_DIR/Xvfb.debug.log --output=$LOGS_DIR/Xvfb.output.log --respawn -- Xvfb :1 -screen 0 800x600x16
EOF
chmod 755 /usr/local/bin/Xvfb-start.sh

tee /usr/local/bin/Xvfb-stop.sh << "EOF"
#!/bin/bash

daemon --stop --verbose --name Xvfb
EOF
chmod 755 /usr/local/bin/Xvfb-stop.sh

tee /usr/local/bin/Xvfb-status.sh << "EOF"
#!/bin/bash

daemon --running --verbose --name Xvfb
EOF
chmod 755 /usr/local/bin/Xvfb-stop.sh
