set -o errexit
set -o xtrace

dpkg --add-architecture i386
apt-get -yqq update || true
apt-get install -qq --assume-yes --no-install-recommends daemon cpu-checker curl git git-lfs ca-certificates zip unzip yandex-openjdk11 qemu-kvm libvirt-bin ubuntu-vm-builder bridge-utils libxdamage1 libxfixes3 libc6:i386 libncurses5:i386 libstdc++6:i386 zlib1g:i386 xvfb
##########################################
# install android sdk tools
# to download the latest version use link from https://developer.android.com/studio
##########################################

curl --verbose --insecure -o sdk-cmdline-tools.zip https://dl.google.com/android/repository/commandlinetools-linux-7583922_latest.zip
unzip sdk-cmdline-tools.zip -d downloads
mkdir -p /usr/local/android-sdk/cmdline-tools
sudo mv /downloads/cmdline-tools /usr/local/android-sdk/cmdline-tools/latest
rm sdk-cmdline-tools.zip

##########################################
# set PATH and other env variables to make all work
##########################################

tee /etc/profile.d/66-android.sh << "EOF"
export ANDROID_HOME=/usr/local/android-sdk
export ANDROID_SDK_HOME=/usr/local/android-sdk
export PATH=$ANDROID_HOME/platform-tools:$ANDROID_HOME/emulator:$ANDROID_HOME/tools:$ANDROID_HOME/cmdline-tools/latest/bin:$PATH
export SHELL=/bin/bash
export LD_LIBRARY_PATH=$ANDROID_HOME/emulator/lib64/:$ANDROID_HOME/emulator/lib64/gles_mesa:$ANDROID_HOME/emulator/lib64/gles_swiftshader:$ANDROID_HOME/emulator/lib64/qt/lib/:$LD_LIBRARY_PATH
ldconfig
EOF

tee /etc/profile.d/55-java.sh << "EOF"
export JAVA_HOME=/usr/local/java
EOF

. /etc/profile

##########################################
# installing android tools
##########################################

yes | sdkmanager --licenses

yes | sdkmanager "tools"
yes | sdkmanager "platform-tools"
yes | sdkmanager "build-tools;28.0.3"
yes | sdkmanager "build-tools;29.0.3"
yes | sdkmanager "build-tools;30.0.2"
yes | sdkmanager "ndk-bundle"
yes | sdkmanager --install "ndk;{ndk_version}" "cmake;{cmake_version}"
export ANDROID_NDK_HOME=/usr/local/android-sdk-linux

chmod -R 0777 /usr/local/android-sdk

##########################################
# add android licenses
##########################################

mkdir -p /usr/local/android-sdk/licenses
echo "" >/usr/local/android-sdk/licenses/android-sdk-license
echo "d56f5187479451eabf01fb78af6dfcb131a6481e" >>/usr/local/android-sdk/licenses/android-sdk-license
echo -n "24333f8a63b6825ea9c5514f83c2829b004d1fee" >>/usr/local/android-sdk/licenses/android-sdk-license
