#!/bin/bash

set -o xtrace
set -o errexit

curl -sSL https://github.com/rvm/rvm/tarball/{version} -o dist-rvm-{version}.tar.gz

mkdir -pv {source}

tar --strip-components=1 -xzf dist-rvm-{version}.tar.gz --directory {source}
cd {source}
./install --ignore-dotfiles --path {destination}

curl -sSL https://curl.haxx.se/ca/cacert.pem -o {destination}/cacert.pem

set +o xtrace

echo ================================================
printenv | sort
echo ================================================
source {destination}/scripts/rvm
echo ================================================
printenv | sort
echo ================================================
