# coding=utf-8
from sandbox import sdk2
from sandbox.projects.metrika.mobile.sdk.generics.generic_tests_runner import GenericTestsRunner
from sandbox.projects.metrika.mobile.sdk.helpers.MacIosHelper import MacIosHelper
from sandbox.projects.metrika.mobile.sdk.parameters.GradleParameters import GradleParameters
from sandbox.projects.metrika.mobile.sdk.parameters.IosParameters import IosBuildParameters


class GenericIosResourceBuilder(GenericTestsRunner):
    """
    """

    class Utils(GenericTestsRunner.Utils):
        ios_helper = MacIosHelper()

    class Requirements(GenericTestsRunner.Requirements):
        disk_space = 50 * 1024

    class Parameters(GenericTestsRunner.Parameters):
        ios_parameters = IosBuildParameters

        resource_path = sdk2.parameters.String("Resource directory", required=True,
                                               description='Путь, который будет сохранен в ресурс')

        use_ssh_key_for_build_task = sdk2.parameters.Bool("Use SSH-key for build task",
                                                          description="Использовать SSH-ключ при сборке",
                                                          default=False)

        with sdk2.parameters.Output:
            output_resource = sdk2.parameters.Resource('Resource', required=True,
                                                       description='Ресурс, содержащий указанную папку/файл')

    def on_save(self):
        super(GenericIosResourceBuilder, self).on_save()
        self.Utils.ios_helper.on_save(self)

    def on_prepare(self):
        super(GenericIosResourceBuilder, self).on_prepare()
        self.Utils.ios_helper.on_prepare(self)

    def on_execute(self):
        with self.repo:
            try:
                with sdk2.helpers.ProgressMeter("Build"):
                    if self.Parameters.use_ssh_key_for_build_task:
                        ssh_key = self.Parameters.ssh_key
                        with sdk2.ssh.Key(self, ssh_key.owner, ssh_key.name):
                            self._build(self._get_gradle_properties())
                    else:
                        self._build(self._get_gradle_properties())
            except Exception:
                self.logger.error("Exception in scenario", exc_info=True)
                raise
            finally:
                with sdk2.helpers.ProgressMeter("Save built resource"):
                    self._save_to_resource()
                self._create_custom_logs_resource(backup=True)

    def _save_to_resource(self):
        output_resource_path = self.path(self._work_dir(self.Parameters.resource_path))
        self.Parameters.output_resource = self.Utils.tar_resource_helper.save_to_resource(
            task=self,
            description="Build Resource",
            current_dir=output_resource_path.parent,
            resource_dir_name=output_resource_path.name,
            ttl=1,
            task_dir=self.path(),
            backup=True
        )

    def _get_gradle_properties(self):
        gradle_properties = super(GenericIosResourceBuilder, self)._get_gradle_properties()
        gradle_properties.update({
            "xcodePath": self.Utils.ios_helper.get_xcode_path(self),
            "xcodeTestOS": self.Parameters.device_os,
            "xcodeTestDevice": self.Parameters.device_model,
        })

        return gradle_properties

    @property
    def env(self):
        try:
            return self._env
        except AttributeError:
            self._env = self.Utils.shell_executor.default_env
            self.Utils.ios_helper.prepare_env(self, self._env)
            GradleParameters.prepare_env(self, self._env)
        return self._env
