# coding=utf-8
import re

from sandbox.common.errors import TaskError


class AdvancedEmulatorConfigHelper:

    def __init__(self):
        self._default_emulators = {
            "17_google_apis": {"api_level": 17, "platform": "x86", "api": "google_apis"},
            "19_google_apis": {"api_level": 19, "platform": "x86", "api": "google_apis"},
            "22_google_apis": {"api_level": 22, "platform": "x86_64", "api": "google_apis"},
            "22_default": {"api_level": 22, "platform": "x86_64", "api": "default"},
            "23_google_apis": {"api_level": 23, "platform": "x86_64", "api": "google_apis"},
            "23_default": {"api_level": 23, "platform": "x86_64", "api": "default"},
            "24_google_apis": {"api_level": 24, "platform": "x86_64", "api": "google_apis"},
            "24_default": {"api_level": 24, "platform": "x86_64", "api": "default"},
            "25_google_apis": {"api_level": 25, "platform": "x86_64", "api": "google_apis"},
            "25_default": {"api_level": 25, "platform": "x86_64", "api": "default"},
            "26_google_apis": {"api_level": 26, "platform": "x86_64", "api": "google_apis"},
            "26_default": {"api_level": 26, "platform": "x86_64", "api": "default"},
            "27_google_apis": {"api_level": 27, "platform": "x86", "api": "google_apis"},
            "27_default": {"api_level": 27, "platform": "x86_64", "api": "default"},
            "28_google_apis": {"api_level": 28, "platform": "x86_64", "api": "google_apis"},
            "28_default": {"api_level": 28, "platform": "x86_64", "api": "default"},
            "29_google_apis": {"api_level": 29, "platform": "x86_64", "api": "google_apis"},
            "29_default": {"api_level": 29, "platform": "x86_64", "api": "default"},
            "30_google_apis": {"api_level": 30, "platform": "x86_64", "api": "google_apis"},
            "31_google_apis": {"api_level": 31, "platform": "x86_64", "api": "google_apis"},
            "32_google_apis": {"api_level": 32, "platform": "x86_64", "api": "google_apis"},
            "33_google_apis": {"api_level": 33, "platform": "x86_64", "api": "google_apis"},
        }
        self.old_matcher = re.compile('^API(?P<api_level>\d+)_(?P<dpi>\d+)_(?P<width>\d+)x(?P<height>\d+).*$')
        self.new_matcher = re.compile('^API(?P<api_level>[^;]+);(?P<platform>[^;]+);(?P<api>[^;]+);(?:_(?P<dpi>\d+)_(?P<width>\d+)x(?P<height>\d+)){0,1}$')

    def get_emulator_config_by_launcher_value(self, launcher_emulator_description):
        return self._default_emulators[launcher_emulator_description]

    def get_display_config(self, advanced_config):
        if self.old_matcher.match(advanced_config):
            display_config = self.old_matcher.match(advanced_config)
            return {
                "density": display_config.group("dpi"),
                "width": display_config.group("width"),
                "height": display_config.group("height")
            }
        else:
            display_config = self.new_matcher.match(advanced_config)
            if display_config and display_config.group("dpi") and display_config.group("width") and display_config.group("height"):
                return {
                    "density": display_config.group("dpi"),
                    "width": display_config.group("width"),
                    "height": display_config.group("height")
                }
            else:
                return {}

    def get_emulator_config(self, advanced_config):
        if self.old_matcher.match(advanced_config):
            emulator_config = self.old_matcher.match(advanced_config)
            return {
                "api_level": emulator_config.group("api_level"),
                "platform": "x86" if emulator_config.group("api_level") in ["17", "19", "27"] else "x86_64",
                "api": "default" if "default" in advanced_config else "google_apis",
            }
        elif self.new_matcher.match(advanced_config):
            emulator_config = self.new_matcher.match(advanced_config)
            return {
                "api_level": emulator_config.group("api_level"),
                "platform": emulator_config.group("platform"),
                "api": emulator_config.group("api"),
            }
        else:
            raise TaskError("Configuration '{}' does not match any of regexp".format(advanced_config))
