# coding=utf-8
from sandbox.common.errors import TaskError
from sandbox.common.types.resource import State
from sandbox.projects.sandbox.resources import LXC_CONTAINER


class AndroidContainerFinder:

    def __init__(self):
        pass

    def get_container(self, container_version, api_level, platform, api):
        emulator_description = {
            "api_level": api_level,
            "api": api,
            "platform": platform,
        }
        container = LXC_CONTAINER.find(**self.__get_filter(container_version, {
            "frankenstein_android_emulator": True,
            "emulator_description": "{api_level};{api};{platform}".format(**emulator_description),
            "version": container_version,
        })).first()

        if not container:
            raise TaskError("Container with description {} not found".format(emulator_description))

        return container

    def get_build_container(self, container_version):
        container = LXC_CONTAINER.find(**self.__get_filter(container_version, {
            "android_gradle_runner": True,
            "version": container_version,
        })).first()

        if not container:
            raise TaskError("Container not found")

        return container

    def __get_filter(self, container_version, attrs):
        filter = {
            "state": State.READY,
            "attrs": attrs,
        }
        if container_version.startswith("stable"):
            filter.update({
                "owner": "METRIKA",
            })
        return filter
